export const config = {
  API_ENDPOINT: 'https://cms.vab.vn/api/',// pro 
  // API_ENDPOINT:'http://103.147.34.34:10700/api/' ,
  // API_IMAGE_ENDPOINT: 'http://103.147.34.34:10700/api/upload/' , // test
  API_IMAGE_ENDPOINT: 'https://cms.vab.vn/file/upload/',

  API_RES_CODE: {
    OK: {
      code: 0,
    },
    TOKEN_INVALID: {
      code: 3,
    },
    TOKEN_EXPIRES: {
      code: 3,
    },
    '-1': {
      code: -1,
    },
  },
  CHANNEL: 'CMS',
};

export enum API_PATHS {
  login = '/user/login',
  
  getUserGroups = '/group/get_list',
  getListPages = '/user/page/list',
  getListGroupUsers = '/user/group/list',
  addNewGroupUser = 'user/group/add',
  deleteGroupUser = '/user/group/delete',
  getUserGroupDetail = '/user/group/detail',
  updateUserGroupInfo = '/user/group/update',
  getListUsers = '/user/list',
  addNewUser = '/user/add',
  deleteUser = '/user/delete',
  resetPassword = '/user/resetPass',
  getUserDetail = '/user/detail',
  updateUser = '/user/update',
  getListUnits = '/artistOwner',
  getListArtists = '/artist',
  getFieldOptions = '/field',
  getNationalityOptions = '/nationality',
  getProvinceOptions = '/common/province',
  getMusicTypeOptions= '/common/musicType',
  getArtistLevelOptions = '/artistLevel',
  getQualificationOptions = '/qualification',
  getWorkOptions = '/work',
  getDetailArtist = '/artist/detail',
  deleteManagingUnits = '/artistOwner/delete',
  deleteArtist = '/artist/delete',
  getArtistDicitionaryOptions = 'artist/dictionary',
  artistOwnerAdd = 'artistOwner/add',
  updateArtist = 'artist/update',
  bankOptions = 'bank',
  cardTypeOptions = 'cardType',
  uploadImage = 'file/upload',
  getDetailUnit = 'artistOwner/detail',
  updateUnit = 'artistOwner/update',
  addArtist = 'artist/add',
  listCustomers = 'customer',
  listCustomerLevel = 'customerLevel',
  addCustomer = 'customer/add',
  deleteCustomer = 'customer/delete',
  browserCustomer = 'customer/accountBrowsing',
  getListCustomersRank = 'customerLevel',
  deleteCustomerRank = 'customerLevel/delete',
  addCustomerRank = 'customerLevel/add',
  updateCustomerRank = 'customerLevel/update',
  getDetailCustomerRank = 'customerLevel/detail',
  getListField = 'field',
  deleteField = 'field/delete',
  addField = 'field/add',
  updateField = 'field/update',
  getDetailField = 'field/detail',
  getListPost = 'post',
  deletePost = 'post/delete',
  detailCustomer = 'customer/detail',
  updateCustomer = 'customer/update',
  getPostCategory = 'postCategory',
  addPost = 'post/add',
  getListCategoryPost = 'postCategory',
  getLanguage = 'language',
  getDetailPost = 'post/detail',
  updatePost = 'post/update',
  addCategoryPost = 'postCategory/add',
  deleteCategoryPost = 'postCategory/delete',
  detailCategoryPost = 'postCategory/detail',
  updateCategoryPost = 'postCategory/update',
  getListBooking = 'booking',
  getBookingDetail = 'booking/detail',
  getArrayArtist = 'artist/arrayArtist',
  getArrayCust = 'customer/arrayCust',
  getlistMenu = 'web-page/list',
  getDetailMenu = 'web-page/detail',
  updateMenu = 'web-page/update',
  addMenu = 'web-page/add',
  deleteMenu = 'web-page/delete',
  getConfigSystem = 'config-page',
  getDetailConfigSystem = 'config-page/detail',
  updateConfigSystem = 'config-page/update',
  addConfigSystem = 'config-page/add',
  deleteConfigSystem = 'config-page/delete',
  getDetailInfoVAB = 'information/detail',
  updateInfoVAB = 'information/update',
  getListVABInfo = 'information',
  getListBanner = 'config/home/banner',
  getDetailBanner = 'config/home/banner/detail',
  addBanner = 'config/home/banner/add',
  updateBanner = 'config/home/banner/update',
  deleteBanner = 'config/home/banner/delete',
  getListConfigPartner = 'config/home/partner',
  deleteConfigPartner = 'config/home/partner/delete',
  addConfigPartner = 'config/home/partner/add',
  getDetailConfigPartner = 'config/home/partner/detail',
  updateConfigPartner = 'config/home/partner/update',
  getListConfigHotProduct = 'config/home/product',
  getDetailConfigHotProduct = 'config/home/product/detail',
  updateConfigHotProduct = 'config/home/product/update/salient',
  addConfigHotProduct = 'config/home/product/add/salient',
  deleteConfigHotProduct = 'config/home/product/delete/salient',
}
