import { i18n } from 'src/boot/i18n';
import { defineComponent, onMounted, Ref, ref } from 'vue';
import Pagination from 'components/pagination/index.vue';
import AddNewBankAccountDialog from 'components/artist-information/bank-account/add-new-bank-account-dialog/index.vue';
export default defineComponent({
  components: {
    Pagination,
    AddNewBankAccountDialog,
  },
  props: {
    bankAccounts: { type: Array, required: true },
  },
  setup() {
    const userTableColumnsBankAccount = [
      {
        name: 'STT',
        required: true,
        label: 'STT',
        align: 'center',
        sortable: false,
      },
      {
        name: 'accountNumber',
        field: 'accountNumber',
        required: true,
        label: i18n.global.t('artist.bankAccount.tableColumnsBank.idCard'),
        align: 'center',
        sortable: false,
      },
      {
        name: 'cardNumber',
        field: 'cardNumber',
        required: true,
        label: i18n.global.t('artist.bankAccount.tableColumnsBank.numberCard'),
        align: 'center',
        sortable: false,
      },
      {
        name: 'bank',
        field: 'bank',
        required: true,
        label: i18n.global.t('artist.bankAccount.tableColumnsBank.bankName'),
        align: 'center',
        sortable: false,
      },
      {
        name: 'cardType',
        field: 'cardType',
        required: true,
        label: i18n.global.t('artist.bankAccount.tableColumnsBank.cardType'),
        align: 'center',
        sortable: false,
      },
      {
        name: 'isDefault',
        field: 'isDefault',
        required: true,
        label: i18n.global.t('artist.bankAccount.tableColumnsBank.default'),
        align: 'center',
        sortable: false,
      },
      {
        name: 'action',
        field: 'action',
        required: true,
        label: i18n.global.t('artist.bankAccount.tableColumnsBank.action'),
        align: 'center',
        sortable: false,
      },
    ];
    const userTableRowsBankAccount: Ref<unknown[]> = ref([]);
    const pageIndex = ref(1);
    const pageSize = ref(20);
    const totalPage = ref(10);
    const isOpenDialog = ref(false);
    const getListBankAccount = () => {
      //   const response = (await api({
      //     url: API_PATHS.getListArtist,
      //     method: 'GET',
      //     params: {
      //       pageIndex: pageIndex.value,
      //       pageSize: pageSize.value,
      //     },
      //   })) as AxiosResponse<BaseResponseBody<unknown>>;
      const fakeData: unknown[] = [
        {
          idCard: 91239381,
          numberCard: '123213123',
          bankName: 'TP Bank',
          cardType: 'Visa',
          default: true,
        },
      ];
      userTableRowsBankAccount.value = fakeData;
    };
    const changePageSize = () => {
      pageIndex.value = 1;
      void getListBankAccount();
    };

    onMounted(() => {
      void getListBankAccount();
    });
    return {
      isOpenDialog,
      userTableColumnsBankAccount,
      userTableRowsBankAccount,
      pageIndex,
      pageSize,
      totalPage,
      getListBankAccount,
      changePageSize,
    };
  },
  emits: ['click:addBankBtn', 'confirmDeleteAccBank', 'clickEditAccBankBtn'],
});
