import { defineComponent, PropType, Ref, ref, watch } from 'vue';
import { i18n } from 'src/boot/i18n';

import { BankAccountType } from 'src/assets/type';
import { Notify } from 'quasar';
import { CardBankType, TypeCardType } from 'src/assets/type';
export default defineComponent({
  props: {
    isOpenAddAccountBankDialog: {
      type: Boolean,
      required: true,
    },
    bankAccounts: {
      type: Array as PropType<BankAccountType[]>,
      required: true,
    },
    cardBankOptions: {
      type: Array as PropType<CardBankType[]>,
      required: true,
    },
    typeBankOptions: {
      type: Array as PropType<TypeCardType[]>,
      required: true,
    },
  },

  setup(props, context) {
    watch(
      () => props.isOpenAddAccountBankDialog,
      (value) => {
        if (value) {
          accountNumber.value = '';
          cardNumber.value = '';
          bank.value = null;
          cardType.value = null;
          isDefault.value = 2;
        }
      }
    );
    const accountNumberRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t(
          'artist.dialogLabel.validateMessages.requireAccountNumber'
        ),
    ];
    const cardNumberRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('artist.dialogLabel.validateMessages.requireCardNumber'),
    ];
    const bankNameRules = [
      (val: number | null) =>
        val !== null ||
        i18n.global.t('artist.dialogLabel.validateMessages.requireCardType'),
    ];
    const cardTypeRules = [
      (val: number | null) =>
        val !== null ||
        i18n.global.t('artist.dialogLabel.validateMessages.requireCardType'),
    ];
    const confirmAddAccBank = () => {
      Notify.create({
        type: 'positive',
        message: i18n.global.t('artist.dialogLabel.validateMessages.addAccess'),
      });
      let bankFilter = {};
      props.cardBankOptions.map((item) => {
        if (item.id === bank.value) {
          bankFilter = item;
        }
      });

      let typeCardFilter = {};
      props.typeBankOptions.map((item) => {
        if (item.id === cardType.value) {
          typeCardFilter = item;
        }
      });
      context.emit('addNewBankAccount', {
        accountNumber: accountNumber.value,
        cardNumber: cardNumber.value,
        bank: bankFilter,
        cardType: typeCardFilter,
        isDefault: isDefault.value,
      });
    };

    const accountNumber: Ref<string> = ref('');
    const cardNumber: Ref<string> = ref('');
    const bank: Ref<number | null> = ref(null);
    const cardType: Ref<number | null> = ref(null);
    const isDefault: Ref<number> = ref(2);

    return {
      defaultStatus,
      accountNumberRules,
      cardNumberRules,
      accountNumber,
      cardNumber,
      bank,
      cardType,
      isDefault,
      bankNameRules,
      cardTypeRules,
      confirmAddAccBank,
    };
  },
  emits: [
    'update:isOpenAddAccountBankDialog',
    'click:CloseBtn',
    'addNewBankAccount',
    'update:accountNumber',
    'update:cardNumber',
    'update:bank',
    'update:cardType',
    'update:isDefault',
  ],
});
