import { defineComponent, ref } from 'vue';
import { i18n } from 'src/boot/i18n';
import { isEmail } from '../../../boot/functions';
import { isMobilePhone } from '../../../boot/functions';
import UploadImage from '../../upload-image/index.vue';
import moment from 'moment';
export default defineComponent({
  props: {
    id: { type: Number, required: true },
    artistCode: { type: String, required: true },
    avatar: { type: String, required: true },
    fullName: { type: String, required: true },
    artistName: { type: String, required: true },
    birthday: { type: String, required: true },
    sex: { type: Number, required: true },
    nationality: { type: Number, required: true },
    status: { type: Number, required: true },
    address: { type: String, required: true },
    fields: { type: Array, required: true },
    works: { type: Number, required: true },
    qualification: { type: Number, required: true },
    artistLevel: { type: Number, required: true },
    phoneNumber: { type: String, required: true },
    email: { type: String, required: true },
    facebook: { type: String, required: true },
    facebookMessage: { type: String, required: true },
    instagram: { type: String, required: true },
    whatsapp: { type: String, required: true },
    sexOptions: { type: Array, required: true },
    fieldOptions: { type: Array, required: true },
    nationalityOptions: { type: Array, required: true },
    professionOptions: { type: Array, required: true },
    artistLevelOptions: { type: Array, required: true },
    workOptions: { type: Array, required: true },
  },
  components: {
    UploadImage,
  },
  setup(_, context) {
    const BirthdayDatePicker = ref(moment().format('YYYY/MM/DD'))
    const selectedFile = (value: FileList) => {
      // console.log(value);
      // console.log(URL.createObjectURL(value[0]));
      context.emit('SetAvatar', {
        file: value[0],
        url: URL.createObjectURL(value[0]),
      });
    };
    const upload = ref(null);
    const uploadBanner = () => {
      // eslint-disable-next-line
      // @ts-ignore
      // eslint-disable-next-line
      upload.value?.click();
    };
    const artistCodeRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireArtistCode'
        ),
    ];
    const fullNameRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireFullName'
        ),
    ];
    const artistNameRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireArtistName'
        ),
    ];
    const birthdayRules = [
      (val?: string) =>
        val !== undefined ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireBirthday'
        ),
    ];
    const emailRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('artist.artistInformation.validateMessages.requireEmail'),
      (val: string) =>
        isEmail(val) ||
        i18n.global.t('artist.artistInformation.validateMessages.isEmail'),
    ];
    const addressRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireAddress'
        ),
    ];
    const phoneNumberRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requirePhoneNumber'
        ),
      (val: string) =>
        isMobilePhone(val) ||
        i18n.global.t('artist.artistInformation.validateMessages.isPhone'),
    ];
    const sexRules = [
      (val?: number) =>
        val !== undefined ||
        i18n.global.t('artist.artistInformation.validateMessages.requireSex'),
    ];
    const nationalityRules = [
      (val?: number) =>
        val !== undefined ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireNationality'
        ),
    ];
    const fieldRules = [
      (val?: number) =>
        val !== undefined ||
        i18n.global.t('artist.artistInformation.validateMessages.requireField'),
    ];
    const workRules = [
      (val?: number) =>
        val !== undefined ||
        i18n.global.t('artist.artistInformation.validateMessages.requiredWork'),
    ];
    const qualificationRules = [
      (val?: number) =>
        val !== undefined ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireQualification'
        ),
    ];
    const artistLevelRules = [
      (val?: number) =>
        val !== undefined ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireArtistLevel'
        ),
    ];
    const deleteAvatar = () => {
      console.log('object');
      context.emit('deleteAvatar');
    };
    const selectDatePicker =(value:string) =>{
      context.emit('UpdateBirtday',fomatDatePicker(value))
    }
    const fomatDatePicker=(value:string)=>{
      return moment(value).format('DD/MM/YYYY')
    }
    return {
      artistCodeRules,
      fullNameRules,
      artistNameRules,
      birthdayRules,
      emailRules,
      addressRules,
      phoneNumberRules,
      sexRules,
      nationalityRules,
      fieldRules,
      workRules,
      qualificationRules,
      artistLevelRules,
      upload,
      uploadBanner,
      selectedFile,
      deleteAvatar,
      BirthdayDatePicker,
      selectDatePicker,
      fomatDatePicker
    };
  },
  emits: [
    'update:artistCode',
    'update:fullName',
    'update:avatar',
    'update:artistName',
    'update:birthday',
    'update:email',
    'update:facebook',
    'update:facebookMessage',
    'update:instagram',
    'update:whatsapp',
    'update:address',
    'update:phoneNumber',
    'update:sex',
    'update:nationality',
    'update:fields',
    'update:works',
    'update:qualification',
    'update:artistLevel',
    'update:status',
    'addNewArtist',
    'SetAvatar',
    'deleteAvatar',
    'UpdateBirtday'
  ],
});
