import { defineComponent } from 'vue';
import { i18n } from 'src/boot/i18n';
import { isEmail } from '../../../boot/functions';
import { isMobilePhone } from '../../../boot/functions';

export default defineComponent({
  props: {
    showDialogUpdate: {
      type: Boolean,
      required: true,
    },
    ratingsOptions: {type: Array, required: true},
    businessTypeOptions: {type: Array, required: true},
    userName: { type: String, required: true },
    customerName: { type: String, required: true },
    businessName: { type: String, required: true },
    taxCode: { type: Number, required: true },
    email: { type: String, required: true },
    ratings: { type: String, required: true },
    address: { type: String, required: true },
    businessType: { type: String, required: true },
    representative: { type: String, required: true },
    position: { type: String, required: true },
    phone: { type: String, required: true },
    status: { type: Boolean, required: true },
  },
  setup() {
    const userNameRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('customer.validateMessages.requireUserName'),
    ];
    const customerNameRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('customer.validateMessages.requireCustomerName'),
    ];
    const businessNameRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('customer.validateMessages.requireBusinessName'),
    ];
    const taxCodeRules = [
        (val?: number) =>
          val !== undefined ||
          i18n.global.t('customer.validateMessages.requireTaxCode'),
      ];
    const phoneRules = [
        (val?: string) =>
          (val && val.trim().length) ||
          i18n.global.t('customer.validateMessages.requirePhone'),
        (val: string) =>
          isMobilePhone(val) ||
          i18n.global.t('customer.validateMessages.isPhone'),
      ];
    const emailRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('customer.validateMessages.requireEmail'),
      (val: string) =>
        isEmail(val) || i18n.global.t('customer.validateMessages.isEmail'),
    ];
    const addressRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('customer.validateMessages.requireAddress'),
    ];
    const businessTypeRules = [
      (val?: number) =>
        val !== undefined ||
        i18n.global.t('customer.validateMessages.requireBusinessType'),
    ];
    const ratingsRules = [
      (val?: number) =>
        val !== undefined ||
        i18n.global.t('customer.validateMessages.requireRatings'),
    ];
    const representativeRules = [
        (val?: string) =>
          (val && val.trim().length) ||
          i18n.global.t('customer.validateMessages.requireRepresentative'),
      ];
      const positionRules = [
        (val?: string) =>
          (val && val.trim().length) ||
          i18n.global.t('customer.validateMessages.requiredPosition'),
      ];
    return {
      userNameRules,
      customerNameRules,
      businessNameRules,
      taxCodeRules,
      emailRules,
      ratingsRules,
      addressRules,
      businessTypeRules,
      representativeRules,
      positionRules,
      phoneRules,
    };
  },
  emits: [
    'update:showDialogUpdate',
    'click:CloseBtn',
    'update:userName',
    'update:customerName',
    'update:businessName',
    'update:taxCode',
    'update:email',
    'update:ratings',
    'update:address',
    'update:businessType',
    'update:representative',
    'update:position',
    'update:phone',
    'update:status',
    'updateNewCustomer',
  ],
});
