import { defineComponent } from 'vue';
import { i18n } from 'src/boot/i18n';
import { isEmail } from '../../../boot/functions';
import { isMobilePhone } from '../../../boot/functions';

export default defineComponent({
  props: {
    showDialogUpdate: {
      type: Boolean,
      required: true,
    },
    fullName: { type: String, required: true },
    email: { type: String, required: true },
    mobileNumber: { type: String, required: true },
    address: { type: String, required: true },
    phoneNumber: { type: String, required: true },
    unit: { type: String, required: true },
    sex: { type: Number, required: true },
    sexOptions: { type: Array, required: true },
    birthday: { type: String, required: true },
    group: { type: Array, required: true },
    listGroup: { type: Array, required: true },
    scheduleAccess: { type: String, required: true },
    listScheduleAccess: { type: Array, required: true },
    status: { type: Boolean, required: true },
  },
  setup() {
    const fullNameRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('userPage.validateMessages.requireFullName'),
    ];
    const emailRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('userPage.validateMessages.requireEmail'),
      (val: string) =>
        isEmail(val) || i18n.global.t('userPage.validateMessages.isEmail'),
    ];
    const mobileNumberRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('userPage.validateMessages.requireMobileNumber'),
      (val: string) =>
        isMobilePhone(val) ||
        i18n.global.t('userPage.validateMessages.isMobilePhone'),
    ];

    const addressRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('userPage.validateMessages.requireAddress'),
    ];
    const unitRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('userPage.validateMessages.requireUnit'),
    ];
    const sexRules = [
      (val?: number) =>
        val !== undefined ||
        i18n.global.t('userPage.validateMessages.requireSex'),
    ];
    const groupRules = [
      (val?: number) =>
        val !== undefined ||
        i18n.global.t('userPage.validateMessages.requiredGroup'),
    ];
    return {
      fullNameRules,
      emailRules,
      mobileNumberRules,
      addressRules,
      unitRules,
      sexRules,
      groupRules,
    };
  },
  emits: [
    'update:showDialogUpdate',
    'click:CloseBtn',
    'update:fullName',
    'update:email',
    'update:mobileNumber',
    'update:address',
    'update:phoneNumber',
    'update:unit',
    'update:sex',
    'update:birthday',
    'update:group',
    'update:scheduleAccess',
    'update:status',
    'updateUser',
  ],
});
