import { defineComponent, onMounted, ref, Ref } from 'vue';
import { api, BaseResponseBody } from 'src/boot/axios';
import { API_PATHS, config } from 'src/assets/configurations';
import { useRoute } from 'vue-router';
import { AxiosResponse } from 'axios';
import moment from 'moment';
import { i18n } from 'src/boot/i18n';
import { Dialog, Notify } from 'quasar';
import { Router } from 'src/router';
import { Pages } from 'src/router/routes';

import PersonalInformation from 'components/artist-information/personal-information/index.vue';
import VabAccount from 'components/artist-information/VAB-account/index.vue';
import BankAccount from 'components/artist-information/bank-account/index.vue';
import HotProduct from 'components/artist-information/hot-product/index.vue';
import AddHotProductDialog from 'components/artist-information/AddHotProduct/index.vue';
import AddNewBankAccountDialog from 'components/artist-information/bank-account/add-new-bank-account-dialog/index.vue';
import EditBankAccountDialog from 'components/artist-information/bank-account/edit-bank-account/index.vue';
import UploadEmbedDialog from 'components/artist-information/upload-embed-dialog/index.vue';
import UpdateHotProduct from 'components/artist-information/UpdateHotProduct/index.vue';
import AddStory from 'components/artist-information/VAB-account/add-story/index.vue';

import {
  ArtistInfoType,
  FieldType,
  NationalityType,
  ArtistLevelType,
  QualificationType,
  WorkType,
  BankAccountType,
  ProductType,
  BannerType,
  StoriesType,
  SchedulesType,
  CardBankType,
  TypeCardType,
} from 'src/assets/type';

export type AvatarType = {
  file?: File;
  url?: string | null;
};
// export type Story = {
//   story?:object |
// };
export default defineComponent({
  components: {
    PersonalInformation,
    VabAccount,
    BankAccount,
    HotProduct,
    AddNewBankAccountDialog,
    EditBankAccountDialog,
    AddHotProductDialog,
    UpdateHotProduct,
    UploadEmbedDialog,
    AddStory,
  },

  setup() {
    const route = useRoute();
    const tab = ref('information');

    // state open dialog
    const isOpenAddAccountBankDialog: Ref<boolean> = ref(false);
    const isOpenEditAccountBankDialog: Ref<boolean> = ref(false);
    const openAddHotProduct: Ref<boolean> = ref(false);
    const openUpdateHotProduct: Ref<boolean> = ref(false);
    const isOpenDialogEmbed: Ref<boolean> = ref(false);
    const isOpenAddStory: Ref<boolean> = ref(false);

    // state
    const fieldOptions: Ref<FieldType[]> = ref([]);
    const nationalityOptions: Ref<NationalityType[]> = ref([]);
    const professionOptions: Ref<QualificationType[]> = ref([]);
    const artistLevelOptions: Ref<ArtistLevelType[]> = ref([]);
    const cardBankOptions: Ref<CardBankType[]> = ref([]);
    const typeBankOptions: Ref<TypeCardType[]> = ref([]);
    const workOptions: Ref<WorkType[]> = ref([]);
    const sexOptions = ref([
      { id: 1, name: 'Nam' },
      { id: 2, name: 'Nữ' },
    ]);

    //state sử dụng trong tab thong-tin-ca-nhan
    const id: Ref<number> = ref(0);
    const account: Ref<string | null> = ref(null);
    const avatar: Ref<string | null> = ref(null);
    const avatarFile: Ref<File | null> = ref(null);
    const artistCode: Ref<string> = ref('');
    const fullName: Ref<string> = ref('');
    const artistName: Ref<string | null | undefined> = ref();
    const birthday: Ref<string | null | undefined> = ref('29/04/2021');
    const sex: Ref<number | undefined> = ref();
    const nationality: Ref<NationalityType | null> = ref(null);
    const qualification: Ref<QualificationType | null> = ref(null);
    const artistLevel: Ref<ArtistLevelType | null> = ref(null);
    const address: Ref<string | null | undefined> = ref();
    const status: Ref<number> = ref(1);
    const fields: Ref<FieldType[]> = ref([]);
    const works: Ref<WorkType[]> = ref([]);
    const phoneNumber: Ref<string | null | undefined> = ref();
    const email: Ref<string | null | undefined> = ref();
    const facebook: Ref<string | null | undefined> = ref();
    const facebookMessage: Ref<string | null | undefined> = ref();
    const instagram: Ref<string | null | undefined> = ref();
    const whatsapp: Ref<string | null | undefined> = ref();

    // state sử dụng trong tab vab account
    const banners: Ref<BannerType[]> = ref([]);
    const shortDescription: Ref<string | null> = ref('');
    const socialEmbedded: Ref<string | null> = ref(null);
    const stories: Ref<StoriesType[]> = ref([]);
    const schedules: Ref<SchedulesType[]> = ref([]);
    const formatSchedules: Ref<string[]> = ref([]);

    //state accountBank
    const bankAccounts: Ref<BankAccountType[]> = ref([]);
    const rowBankAccIdx: Ref<number> = ref(0);
    const rowDataAccBank: Ref<BankAccountType | null> = ref(null);

    //satate hot product
    const products: Ref<ProductType[]> = ref([]);
    const statusHotProduct: Ref<number> = ref(2);
    const DataInsertHotProduct: Ref<ProductType | null> = ref(null);
    const DataUpdateHotProduct: Ref<ProductType | null> = ref(null);

    const getInformationArtist = async () => {
      const response = (await api({
        url: API_PATHS.getDetailArtist,
        method: 'GET',
        params: { artistId: route.params.id },
      })) as AxiosResponse<BaseResponseBody<ArtistInfoType>>;
      console.log(response, 'Artist Detail Info');
      const ArtistInformation = response.data.data;
      id.value = ArtistInformation.id;
      avatar.value = ArtistInformation.avatar;
      account.value = ArtistInformation.account;
      artistCode.value = ArtistInformation.artistCode;
      fullName.value = ArtistInformation.fullName;
      artistName.value = ArtistInformation.artistName;
      birthday.value = moment(
        ArtistInformation.birthday,
        'DD/MM/YYYY HH:mm:ss'
      ).format('YYYY-MM-DD');
      address.value = ArtistInformation.address;
      status.value = ArtistInformation.status;
      phoneNumber.value = ArtistInformation.phoneNumber;
      email.value = ArtistInformation.email;
      facebook.value = ArtistInformation.facebook;
      facebookMessage.value = ArtistInformation.facebookMessage;
      instagram.value = ArtistInformation.instagram;
      whatsapp.value = ArtistInformation.whatsapp;
      nationality.value = ArtistInformation.nationality;
      qualification.value = ArtistInformation.qualification;
      works.value = ArtistInformation.works;
      artistLevel.value = ArtistInformation.artistLevel;
      sex.value = ArtistInformation.sex;
      fields.value = ArtistInformation.fields;
      bankAccounts.value = ArtistInformation.bankAccounts;
      products.value = ArtistInformation.products;
      banners.value = ArtistInformation.banners || [];
      socialEmbedded.value = ArtistInformation.socialEmbedded;
      stories.value = ArtistInformation.stories;
      schedules.value = ArtistInformation.schedules;
      for (let index = 0; index < schedules.value.length; index++) {
        const element = schedules.value[index];

        formatSchedules.value.push(
          moment(element.scheduleTime, 'DD/MM/YYYY HH:mm:ss').format(
            'YYYY/MM/DD'
          )
        );
      }
    };

    const getFieldOptions = async () => {
      const response = (await api({
        url: API_PATHS.getFieldOptions,
        method: 'GET',
        params: {},
      })) as AxiosResponse<BaseResponseBody<FieldType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        fieldOptions.value = response.data.data;
        console.log(fieldOptions.value, 'fieldOptions');
      }
    };

    const getNationalityOptions = async () => {
      const response = (await api({
        url: API_PATHS.getNationalityOptions,
        method: 'GET',
        params: {},
      })) as AxiosResponse<BaseResponseBody<NationalityType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        nationalityOptions.value = response.data.data;
      }
    };
    const getArtistLevelOptions = async () => {
      const response = (await api({
        url: API_PATHS.getArtistLevelOptions,
        method: 'GET',
        params: {},
      })) as AxiosResponse<BaseResponseBody<ArtistLevelType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        artistLevelOptions.value = response.data.data;
      }
    };
    const getQualificationOptions = async () => {
      const response = (await api({
        url: API_PATHS.getQualificationOptions,
        method: 'GET',
        params: {},
      })) as AxiosResponse<BaseResponseBody<QualificationType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        professionOptions.value = response.data.data;
      }
    };
    const getWorkOptions = async () => {
      const response = (await api({
        url: API_PATHS.getWorkOptions,
        method: 'GET',
        params: {
          // fieldId: fields.value[0].id,
        },
      })) as AxiosResponse<BaseResponseBody<WorkType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        workOptions.value = response.data.data;
      }
    };
    const getBankOptions = async () => {
      const response = (await api({
        url: API_PATHS.bankOptions,
        method: 'GET',
        params: {},
      })) as AxiosResponse<BaseResponseBody<CardBankType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        cardBankOptions.value = response.data.data;
      }
    };
    const getTypeCardOptions = async () => {
      const response = (await api({
        url: API_PATHS.cardTypeOptions,
        method: 'GET',
        params: {},
      })) as AxiosResponse<BaseResponseBody<TypeCardType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        typeBankOptions.value = response.data.data;
      }
    };

    const addAccBank = (item: BankAccountType) => {
      if (item.isDefault === 1) {
        bankAccounts.value.forEach((element) => (element.isDefault = 2));
        bankAccounts.value.push(item);
        isOpenAddAccountBankDialog.value = false;
      } else {
        bankAccounts.value.push(item);
        isOpenAddAccountBankDialog.value = false;
      }
    };
    const editAccBank = (item: BankAccountType) => {
      if (item.isDefault === 1) {
        bankAccounts.value.forEach((element) => (element.isDefault = 2));
        bankAccounts.value[rowBankAccIdx.value] = item;
        isOpenEditAccountBankDialog.value = false;
      } else {
        bankAccounts.value[rowBankAccIdx.value] = item;
        isOpenEditAccountBankDialog.value = false;
      }
    };
    const confirmDeleteAccBank = (value: number) => {
      Dialog.create({
        title: i18n.global.t(
          'artist.bankAccount.confirmActionsTitle.confirmDeleteAccBankTitle'
        ),
        message: i18n.global.t(
          'artist.bankAccount.confirmActionsTitle.confirmDeleteAccBankContent'
        ),
        cancel: i18n.global.t(
          'artist.bankAccount.confirmActionsTitle.confirmDeleteAccBankBtnLabel'
        ),
        color: 'negative',
      }).onOk(() => {
        Notify.create({
          type: 'positive',
          message: i18n.global.t(
            'artist.dialogLabel.validateMessages.deleteAccess'
          ),
        });
        bankAccounts.value.splice(value, 1);
      });
    };
    const openDialogEditAccBank = (
      itemData: BankAccountType,
      itemIdx: number
    ) => {
      console.log(itemData, 'rowData');
      rowDataAccBank.value = itemData;
      rowBankAccIdx.value = itemIdx;
      console.log(rowBankAccIdx.value);

      isOpenEditAccountBankDialog.value = true;
    };

    const pushData = (value: ProductType) => {
      products.value.push(value);
    };

    const selectedFile = (value: BannerType) => {
      banners.value.push(value);
      console.log(banners.value);
    };
    const reset = ref(null);
    const resetOldData = () => {
      document.getElementById('reset')?.click();
    };
    const confirmDeleteRow = (value: number) => {
      Dialog.create({
        title: i18n.global.t(
          'artist.bankAccount.confirmActionsTitle.confirmDeleteAccBankTitle'
        ),
        message: i18n.global.t(
          'artist.bankAccount.confirmActionsTitle.confirmDeleteAccBankContent'
        ),
        cancel: i18n.global.t(
          'artist.bankAccount.confirmActionsTitle.confirmDeleteAccBankBtnLabel'
        ),
        color: 'negative',
      }).onOk(() => {
        products.value.splice(value, 1);
      });
    };
    const UpdateData = (value: ProductType) => {
      for (let i = 0; i < products.value.length; i++) {
        if (products.value[i].id === value?.id) {
          products.value[i] = value;
        }
      }
    };
    const SetProduct = (value: ProductType) => {
      DataUpdateHotProduct.value = value;
    };
    const setAvatar = (value: BannerType) => {
      console.log(value);
      avatarFile.value = value.file as File;
      avatar.value = value.url as string;
    };

    const confirmDeleteSocialEmbedded = () => {
      Dialog.create({
        title: i18n.global.t(
          'artist.bankAccount.confirmActionsTitle.confirmDeleteAccBankTitle'
        ),
        message: i18n.global.t(
          'artist.confirmActionsTitle.confirmDeleteEmbedContent'
        ),
        cancel: i18n.global.t(
          'artist.bankAccount.confirmActionsTitle.confirmDeleteAccBankBtnLabel'
        ),
        color: 'negative',
      }).onOk(() => {
        socialEmbedded.value = null;
      });
    };

    const changeEmbed = (newEmbed: string | null) => {
      socialEmbedded.value = newEmbed;
      console.log(newEmbed, 'newEmbed');

      isOpenDialogEmbed.value = false;
    };

    const addStory = (value: StoriesType) => {
      stories.value.push(value);
    };

    const deleteStory = (idx: number) => {
      Dialog.create({
        title: i18n.global.t(
          'artist.bankAccount.confirmActionsTitle.confirmDeleteAccBankTitle'
        ),
        message: i18n.global.t(
          'artist.vabAccount.confirmActionsTitle.confirmDeleteStory'
        ),
        cancel: i18n.global.t(
          'artist.bankAccount.confirmActionsTitle.confirmDeleteAccBankBtnLabel'
        ),
        color: 'negative',
      }).onOk(() => {
        Notify.create({
          type: 'positive',
          message: i18n.global.t(
            'artist.dialogLabel.validateMessages.deleteStoryAccess'
          ),
        });
        stories.value.splice(idx, 1);
      });
    };
    // const callApiUploadImage = async (file: File) => {
    //   try {
    //     const response = await api({
    //       url: API_PATHS.uploadImage,
    //       method: 'GET',
    //       params: {},
    //     });
    //   } catch (error) {}
    // };
    const UpdateBirtday = (value: string) => {
      // console.log(value);
      birthday.value = value;
    };
    const updateInformationArtist = async () => {
      try {
        const response = (await api({
          url: API_PATHS.updateArtist,
          method: 'POST',
          data: {
            id: route.params.id,
            avatar: avatar.value,
            artistCode: artistCode.value,
            artistName: artistName.value,
             // eslint-disable-next-line @typescript-eslint/restrict-plus-operands
            birthday: birthday.value + ' 00:00:00',
            sex: sex.value,
            address: address.value,
            phoneNumber: phoneNumber.value,
            email: email.value,
            facebook: facebook.value,
            facebookMessage: facebookMessage.value,
            instagram: instagram.value,
            whatsapp: whatsapp.value,
            fullName: fullName.value,
            // "workStatus": 1,
            shortDescription: null,
            account: null,
            socialEmbedded: socialEmbedded.value,
            artistLevel: artistLevel.value,
            fields: fields.value,
            nationality: nationality.value,
            qualification: qualification.value,
            works: works.value,
            banners: banners.value,
            bankAccounts: bankAccounts.value,
            schedules: schedules.value,
            stories: stories.value,
            products: products.value,
          },
        })) as AxiosResponse<BaseResponseBody<unknown>>;
        if (response.data.error.code === config.API_RES_CODE.OK.code) {
          await Router.push({ name: Pages.artist });
          Notify.create({
            type: 'positive',
            message: i18n.global.t('artist.actionMessages.editArtistAccess'),
          });
        }
      } catch (error) {}
    };
    const deleteImagesStories = (value: number) => {
      console.log(value, 'deleteImagesStories');
      console.log(stories.value);
    };
    const DeleteItemStories = (value: StoriesType) => {
      for (let i = 0; i < stories.value.length; i++) {
        if (stories.value[i].id == value.id) {
          console.log(1);
          stories.value.splice(Number(stories.value[i]), 1);
        }
      }
      console.log(stories.value);
    };

    const deleteAvatar = () => {
      avatar.value = null;
    };
    onMounted(() => {
      void getInformationArtist();
      void getFieldOptions();
      void getNationalityOptions();
      void getArtistLevelOptions();
      void getQualificationOptions();
      void getWorkOptions();
      void getBankOptions();
      void getTypeCardOptions();
    });
    return {
      tab,
      getInformationArtist,
      id,
      route,
      artistCode,
      fullName,
      artistName,
      birthday,
      sex,
      nationality,
      address,
      status,
      fields,
      works,
      qualification,
      artistLevel,
      phoneNumber,
      email,
      facebook,
      facebookMessage,
      instagram,
      whatsapp,
      socialEmbedded,
      sexOptions,
      fieldOptions,
      nationalityOptions,
      professionOptions,
      artistLevelOptions,
      workOptions,
      getFieldOptions,
      getNationalityOptions,
      getArtistLevelOptions,
      getQualificationOptions,
      getWorkOptions,
      bankAccounts,
      products,
      account,
      banners,
      shortDescription,
      stories,
      isOpenAddAccountBankDialog,
      openAddHotProduct,
      addAccBank,
      schedules,
      formatSchedules,
      confirmDeleteAccBank,
      selectedFile,
      isOpenDialogEmbed,
      cardBankOptions,
      typeBankOptions,
      isOpenEditAccountBankDialog,
      openDialogEditAccBank,
      editAccBank,
      rowBankAccIdx,
      statusHotProduct,
      DataInsertHotProduct,
      pushData,
      resetOldData,
      reset,
      confirmDeleteRow,
      updateInformationArtist,
      openUpdateHotProduct,
      SetProduct,
      DataUpdateHotProduct,
      UpdateData,
      getBankOptions,
      getTypeCardOptions,
      rowDataAccBank,
      avatar,
      setAvatar,
      deleteAvatar,
      deleteImagesStories,
      DeleteItemStories,
      confirmDeleteSocialEmbedded,
      changeEmbed,
      isOpenAddStory,
      addStory,
      deleteStory,
      UpdateBirtday,
    };
  },
});
