import { i18n } from 'src/boot/i18n';
import { defineComponent, onMounted, Ref, ref } from 'vue';
import Pagination from 'components/pagination/index.vue';
import AddNewCustomerDialogComponent from '../../components/customer/add-new-customer-dialog/index.vue';
import UpdateNewCustomerDialogComponent from '../../components/customer/update-new-customer-dialog/index.vue';
import { API_PATHS, config } from 'src/assets/configurations';
import { AxiosResponse } from 'axios';
import { api, BaseResponseBody } from 'src/boot/axios';
import {
  CustomerType,
  PaginationResponse,
  CustomerLevelType,
} from 'src/assets/type';
import { Dialog, Notify } from 'quasar';
export default defineComponent({
  components: {
    AddNewCustomerDialogComponent,
    UpdateNewCustomerDialogComponent,
    Pagination,
  },
  setup() {
    const dataTest = ref([]);
    const userTableColumnsCustomer = [
      {
        name: 'stt',
        field: 'stt',
        required: true,
        label: i18n.global.t('customer.tableColumnsCustomer.stt'),
        align: 'center',
        sortable: false,
      },
      {
        name: 'code',
        field: 'code',
        required: true,
        label: i18n.global.t('customer.tableColumnsCustomer.customerCode'),
        align: 'center',
        headerStyle: 'text-align: center !important;',
        sortable: false,
      },
      {
        name: 'userName',
        field: 'userName',
        required: true,
        label: i18n.global.t('customer.tableColumnsCustomer.userName'),
        headerStyle: 'text-align: center !important;',
        align: 'left',
        sortable: false,
      },
      {
        name: 'fullName',
        field: 'fullName',
        required: true,
        label: i18n.global.t('customer.tableColumnsCustomer.fullName'),
        headerStyle: 'text-align: center !important;',
        align: 'left',
        sortable: false,
      },
      {
        name: 'companyName',
        field: 'companyName',
        required: true,
        label: i18n.global.t('customer.tableColumnsCustomer.businessName'),
        headerStyle: 'text-align: center !important;',
        align: 'left',
        sortable: false,
      },
      {
        name: 'taxCode',
        field: 'taxCode',
        required: true,
        label: i18n.global.t('customer.tableColumnsCustomer.taxCode'),
        headerStyle: 'text-align: center !important;',
        align: 'left',
        sortable: false,
      },
      {
        name: 'email',
        field: 'email',
        required: true,
        label: i18n.global.t('customer.tableColumnsCustomer.email'),
        headerStyle: 'text-align: center !important;',
        align: 'left',
        sortable: false,
      },
      {
        name: 'level',
        field: 'level',
        required: true,
        label: i18n.global.t('customer.tableColumnsCustomer.ratings'),
        headerStyle: 'text-align: center !important;',
        align: 'left',
        sortable: false,
      },
      {
        name: 'status',
        field: 'status',
        required: true,
        label: i18n.global.t('customer.tableColumnsCustomer.status'),
        align: 'center',
        sortable: false,
      },
      {
        name: 'action',
        field: 'action',
        required: true,
        label: i18n.global.t('customer.tableColumnsCustomer.action'),
        align: 'center',
        sortable: false,
      },
    ];
    const userTableRowsCustomer: Ref<unknown[]> = ref([]);
    const showDialog = ref(false);
    const showDialogUpdate = ref(false);
    const pageIndex = ref(1);
    const pageSize = ref(20);
    const totalPage = ref(10);
    const companyNameSelected: Ref<string | null> = ref(null);
    const taxCodeSelected: Ref<string | null> = ref(null);
    const levelSelected: Ref<CustomerLevelType | null> = ref(null);

    const id: Ref<number | undefined> = ref(undefined);
    const code: Ref<string | null> = ref(null);
    const userName: Ref<string | null> = ref(null);
    const fullName: Ref<string | null> = ref(null);
    const companyName: Ref<string | null> = ref(null);
    const taxCode: Ref<string | null> = ref(null);
    const email: Ref<string | null> = ref(null);
    const status: Ref<number | null> = ref(2);
    const phone: Ref<string | null> = ref(null);
    const password: Ref<string | null> = ref(null);
    const address: Ref<string | null> = ref(null);
    const type: Ref<string | null> = ref(null);
    const representative: Ref<string | null> = ref(null);
    const position: Ref<string | null> = ref(null);
    const level: Ref<CustomerLevelType | null> = ref(null);

    const levelOptions: Ref<CustomerLevelType[] | null> = ref([]);
    const getListCustomers = async () => {
      try {
        const response = (await api({
          url: API_PATHS.listCustomers,
          method: 'GET',
          params: {
            pageIndex: pageIndex.value,
            pageSize: pageSize.value,
            customerLevel: levelSelected.value?.id,
          },
        })) as AxiosResponse<
          BaseResponseBody<PaginationResponse<CustomerType>>
        >;
        if (response.data.error.code === config.API_RES_CODE.OK.code) {
          userTableRowsCustomer.value = response.data.data.data;
          totalPage.value = response.data.data.totalPages;
          console.log(response.data.data);
        }
      } catch (error) {}
    };
    const getCustomerLevelOptions = async () => {
      const response = (await api({
        url: API_PATHS.listCustomerLevel,
        method: 'GET',
        params: {},
      })) as AxiosResponse<BaseResponseBody<CustomerLevelType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        levelOptions.value = response.data.data;
      }
    };
    const confirmDeleteCustomer = (id: number) => {
      Dialog.create({
        title: i18n.global.t(
          'customer.confirmActionsTitle.confirmDeleteUserTitle'
        ),
        message: i18n.global.t(
          'customer.confirmActionsTitle.confirmDeleteUserContent'
        ),
        cancel: i18n.global.t(
          'customer.confirmActionsTitle.confirmDeleteUserCancelBtnLabel'
        ),
        color: 'negative',
      }).onOk(() => {
        void deleteCustomer(id);
      });
    };
    const deleteCustomer = async (id: number) => {
      try {
        const deleteResult = (await api({
          url: API_PATHS.deleteCustomer,
          method: 'GET',
          params: {
            id: id,
          },
        })) as AxiosResponse<BaseResponseBody<unknown>>;

        if (deleteResult.data.error.code === config.API_RES_CODE.OK.code) {
          Notify.create({
            type: 'positive',
            message: i18n.global.t('customer.actionMessages.deleteUserAccess'),
          });
          void getListCustomers();
        }
      } catch (error) {}
    };
    const addCustomer = async (item: CustomerType) => {
      try {
        const response = (await api({
          url: API_PATHS.addCustomer,
          method: 'POST',
          data: {
            code: item.code,
            userName: item.userName,
            fullName: item.fullName,
            companyName: item.companyName,
            taxCode: item.taxCode,
            email: item.email,
            status: item.status,
            phone: item.phone,
            password: item.password,
            address: item.address,
            type: item.type,
            representative: item.representative,
            position: item.position,
            level: item.level,
          },
        })) as AxiosResponse<BaseResponseBody<unknown>>;
        if (response.data.error.code === config.API_RES_CODE.OK.code) {
          Notify.create({
            type: 'positive',
            message: i18n.global.t('artist.actionMessages.addNewArtistAccess'),
          });
          void getListCustomers();
          showDialog.value = false;
        }
      } catch (error) {}
    };
    const changePageSize = () => {
      pageIndex.value = 1;
      void getListCustomers();
    };

    const openAddCustomerDialog = () => {
      showDialog.value = true;
      userName.value = null;
      fullName.value = null;
      companyName.value = null;
      taxCode.value = null;
      email.value = null;
      level.value = null;
      address.value = null;
      type.value = null;
      representative.value = null;
      position.value = null;
      phone.value = null;
      status.value = 2;
    };

    const getDetailCustomer = () => {
      // gọi api chi tiết cần có id để lấy value cho từng customer
      // const response = (await api({
      //   url: ...,
      //   method: 'GET',
      //   params: {
      //     id: id
      //   }
      // }))
      // gọi api lấy chi tiết sau đấy gán giá trị api trả về gán cho các biến userName customerName businessName taxCode...
      const fakeDataDetail = {
        userName: 'Sơn Tùng',
      };
      userName.value = fakeDataDetail.userName;
      // Tương tự các biến còn lại
    };
    const openUpdateCustomerDialog = (id: number) => {
      showDialogUpdate.value = true;
      console.log(id, 'iddd');
      void getDetailCustomer();
    };

    //Bấm nút lưu ở dialog update thì gọi api cập nhật trong hàm updateCustomer
    const updateCustomer = () => {
      //gọi api update
      try {
      } catch (error) {}
    };

    onMounted(() => {
      void getListCustomers();
      void getCustomerLevelOptions();
    });
    return {
      openUpdateCustomerDialog,
      updateCustomer,
      openAddCustomerDialog,
      addCustomer,
      showDialogUpdate,
      showDialog,
      id,
      userName,
      fullName,
      companyName,
      taxCode,
      code,
      password,
      type,
      email,
      level,
      levelOptions,
      address,
      representative,
      position,
      levelSelected,
      phone,
      companyNameSelected,
      taxCodeSelected,
      status,
      userTableColumnsCustomer,
      userTableRowsCustomer,
      getListCustomers,
      pageIndex,
      pageSize,
      dataTest,
      totalPage,
      changePageSize,
      getCustomerLevelOptions,
      confirmDeleteCustomer,
    };
  },
});
