import { i18n } from 'src/boot/i18n';
import { defineComponent, onMounted, ref, Ref } from 'vue';
import { Dialog, Notify } from 'quasar';
import {
  PaginationResponse,
  ArtistInfoType,
  FieldType,
  NationalityType,
  ArtistLevelType,
  QualificationType,
  WorkType,
} from 'src/assets/type';
import Pagination from 'components/pagination/index.vue';
import { api, BaseResponseBody } from 'src/boot/axios';
import { API_PATHS, config } from 'src/assets/configurations';
import { AxiosResponse } from 'axios';
export default defineComponent({
  components: {
    Pagination,
  },
  setup() {
    const userTableColumnsArtist = [
      {
        required: true,
        name: 'STT',
        field: 'STT',
        label: 'STT',
        align: 'center',
        sortable: false,
      },
      {
        name: 'artistCode',
        field: 'artistCode',
        required: true,
        label: i18n.global.t('artist.tableColumnsArtist.artistCode'),
        headerStyle: 'text-align: center !important;',
        align: 'left',
        sortable: false,
      },
      {
        name: 'fullName',
        field: 'fullName',
        required: true,
        label: i18n.global.t('artist.tableColumnsArtist.fullName'),
        headerStyle: 'text-align: center !important;',
        align: 'left',
        sortable: false,
      },
      {
        name: 'artistName',
        field: 'artistName',
        required: true,
        label: i18n.global.t('artist.tableColumnsArtist.artistName'),
        headerStyle: 'text-align: center !important;',
        align: 'left',
        sortable: false,
      },
      {
        name: 'avatar',
        field: 'avatar',
        required: true,
        label: i18n.global.t('artist.tableColumnsArtist.avatar'),
        headerStyle: 'text-align: center !important;',
        align: 'left',
        sortable: false,
      },
      {
        name: 'field',
        field: 'field',
        required: true,
        label: i18n.global.t('artist.tableColumnsArtist.field'),
        headerStyle: 'text-align: center !important;',
        align: 'left',
        sortable: false,
      },
      {
        name: 'work',
        field: 'work',
        required: true,
        label: i18n.global.t('artist.tableColumnsArtist.work'),
        headerStyle: 'text-align: center !important;',
        align: 'left',
        sortable: false,
      },
      {
        name: 'qualification',
        field: 'qualification',
        required: true,
        label: i18n.global.t('artist.tableColumnsArtist.qualification'),
        headerStyle: 'text-align: center !important;',
        align: 'left',
        sortable: false,
      },
      {
        name: 'artistLevel',
        field: 'artistLevel',
        required: true,
        label: i18n.global.t('artist.tableColumnsArtist.artistLevel'),
        headerStyle: 'text-align: center !important;',
        align: 'left',
        sortable: false,
      },
      {
        name: 'action',
        field: 'action',
        required: true,
        label: i18n.global.t('artist.tableColumnsArtist.action'),
        headerStyle: 'text-align: center !important;',
        align: 'center',
        sortable: false,
      },
    ];
    const userTableRowsArtist: Ref<unknown[]> = ref([]);
    const pageIndex = ref(1);
    const pageSize = ref(20);
    const totalPage = ref(10);
    const fullNameKeyword = ref('');
    const sexOptions = ref([
      { id: 1, name: 'Nam' },
      { id: 2, name: 'Nữ' },
    ]);
    const fieldOptions: Ref<FieldType[]> = ref([]);
    const nationalityOptions: Ref<NationalityType[]> = ref([]);
    const professionOptions: Ref<QualificationType[]> = ref([]);
    const artistLevelOptions: Ref<ArtistLevelType[]> = ref([]);
    const workOptions: Ref<WorkType[]> = ref([]);
    const fieldSelected: Ref<FieldType | null> = ref(null);
    const professionSelected: Ref<QualificationType | null> = ref(null);
    const artistLevelSelected: Ref<ArtistLevelType | null> = ref(null);

    const isOpenNewArtistDialog = ref(false);
    const id: Ref<number> = ref(0);
    const artistCode: Ref<string> = ref('');
    const fullName: Ref<string> = ref('');
    const artistName: Ref<string | undefined> = ref();
    const birthday: Ref<string | undefined> = ref();
    const sex: Ref<number | undefined> = ref();
    const nationality: Ref<number | undefined> = ref();
    const address: Ref<string | undefined> = ref();
    const status: Ref<number> = ref(1);
    const field: Ref<number | undefined> = ref();
    const work: Ref<number | undefined> = ref();
    const qualification: Ref<number | undefined> = ref();
    const artistLevel: Ref<number | undefined> = ref();
    const phoneNumber: Ref<string | undefined> = ref();
    const email: Ref<string | undefined> = ref();
    const facebook: Ref<string | undefined> = ref();
    const facebookMessage: Ref<string | undefined> = ref();
    const instagram: Ref<string | undefined> = ref();
    const whatsapp: Ref<string | undefined> = ref();

    const getListArtists = async () => {
      try {
        const response = (await api({
          url: API_PATHS.getListArtists,
          method: 'GET',
          params: {
            pageIndex: pageIndex.value,
            pageSize: pageSize.value,
            qualification: fieldSelected.value?.id,
            artistLevel: professionSelected.value?.id,
            field: artistLevelSelected.value?.id,
          },
        })) as AxiosResponse<
          BaseResponseBody<PaginationResponse<ArtistInfoType>>
        >;
        if (response.data.error.code === config.API_RES_CODE.OK.code) {
          userTableRowsArtist.value = response.data.data.data;
          totalPage.value = response.data.data.totalPages;
          console.log(response.data.data);
        }
      } catch (error) {}
      // userTableRowsArtist.value = fakeData;
    };
    // const filterListArtist = async () => {
    //   try {
    //     const response = (await api({
    //       url: API_PATHS.getListArtists,
    //       method: 'GET',
    //       params: {
    //         pageIndex: pageIndex.value,
    //         pageSize: pageSize.value,
    //         name: fullNameKeyword.value,

    //       },
    //     })) as AxiosResponse<
    //       BaseResponseBody<PaginationResponse<ArtistInfoType>>
    //     >;
    //     if (response.data.error.code === config.API_RES_CODE.OK.code) {
    //       userTableRowsArtist.value = response.data.data.data;
    //       totalPage.value = response.data.data.totalPages;
    //     }
    //   } catch (error) {}
    // };
    const changePageSize = () => {
      pageIndex.value = 1;
      void getListArtists();
    };
    const getFieldOptions = async () => {
      const response = (await api({
        url: API_PATHS.getFieldOptions,
        method: 'GET',
        params: {},
      })) as AxiosResponse<BaseResponseBody<FieldType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        fieldOptions.value = response.data.data;
      }
    };
    const getNationalityOptions = async () => {
      const response = (await api({
        url: API_PATHS.getNationalityOptions,
        method: 'GET',
        params: {},
      })) as AxiosResponse<BaseResponseBody<NationalityType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        nationalityOptions.value = response.data.data;
      }
    };
    const getArtistLevelOptions = async () => {
      const response = (await api({
        url: API_PATHS.getArtistLevelOptions,
        method: 'GET',
        params: {},
      })) as AxiosResponse<BaseResponseBody<ArtistLevelType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        artistLevelOptions.value = response.data.data;
      }
    };
    const getQualificationOptions = async () => {
      const response = (await api({
        url: API_PATHS.getQualificationOptions,
        method: 'GET',
        params: {},
      })) as AxiosResponse<BaseResponseBody<QualificationType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        professionOptions.value = response.data.data;
      }
    };
    const getWorkOptions = async () => {
      const response = (await api({
        url: API_PATHS.getWorkOptions,
        method: 'GET',
        params: {},
      })) as AxiosResponse<BaseResponseBody<WorkType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        workOptions.value = response.data.data;
      }
    };

    const confirmDeleteArtist = (id: number) => {
      Dialog.create({
        title: i18n.global.t(
          'artist.confirmActionsTitle.confirmDeleteArtistTitle'
        ),
        message: i18n.global.t(
          'artist.confirmActionsTitle.confirmDeleteArtistContent'
        ),
        cancel: i18n.global.t(
          'artist.confirmActionsTitle.confirmDeleteArtistBtnLabel'
        ),
        color: 'negative',
      }).onOk(() => {
        void deleteArtist(id);
      });
    };
    const deleteArtist = async (id: number) => {
      try {
        const deleteResult = (await api({
          url: API_PATHS.deleteArtist,
          method: 'GET',
          params: {
            artistId: id,
          },
        })) as AxiosResponse<BaseResponseBody<unknown>>;

        if (deleteResult.data.error.code === config.API_RES_CODE.OK.code) {
          Notify.create({
            type: 'positive',
            message: i18n.global.t('artist.actionMessages.deleteArtistAccess'),
          });
          void getListArtists();
        }
      } catch (error) {}
    };
    onMounted(() => {
      void getListArtists();
      void getFieldOptions();
      void getNationalityOptions();
      void getArtistLevelOptions();
      void getQualificationOptions();
      void getWorkOptions();
    });
    return {
      userTableColumnsArtist,
      userTableRowsArtist,
      getListArtists,
      pageIndex,
      pageSize,
      isOpenNewArtistDialog,
      id,
      artistCode,
      fullName,
      artistName,
      birthday,
      sex,
      nationality,
      address,
      status,
      field,
      work,
      qualification,
      artistLevel,
      phoneNumber,
      email,
      facebook,
      facebookMessage,
      instagram,
      whatsapp,
      sexOptions,
      // filterListArtist,
      totalPage,
      changePageSize,
      fullNameKeyword,
      fieldSelected,
      fieldOptions,
      professionSelected,
      professionOptions,
      artistLevelSelected,
      artistLevelOptions,
      getFieldOptions,
      nationalityOptions,
      getNationalityOptions,
      workOptions,
      getArtistLevelOptions,
      getQualificationOptions,
      getWorkOptions,
      confirmDeleteArtist,
      deleteArtist,
    };
  },
});
