import { RouteRecordRaw } from 'vue-router';

export enum Pages {
  home = 'home',
  login = 'login',
  groupUsers = 'nhom-nguoi-dung',
  cmsUser = 'nguoi-dung',
  managingUnit = 'don-vi-chu-quan',
  artist = 'nghe-sy',
  informationArtist = 'cap-nhat-thong-tin-nghe-sy',
  customer = 'khach-hang',
  addArtist = 'them-nghe-sy',
}

const routes: RouteRecordRaw[] = [
  {
    path: '/',
    component: () => import('layouts/MainLayout.vue'),
    children: [
      {
        path: '',
        component: () => import('pages/Index.vue'),
        name: Pages.home,
      },
      {
        path: '/login',
        component: () => import('pages/login/index.vue'),
        name: Pages.login,
      },
      {
        path: '/nhom-nguoi-dung',
        component: () => import('pages/nhom-nguoi-dung/index.vue'),
        name: Pages.groupUsers,
      },
      {
        path: '/nguoi-dung',
        component: () => import('pages/nguoi-dung/index.vue'),
        name: Pages.cmsUser,
      },
      {
        path: '/don-vi-chu-quan',
        component: () => import('pages/don-vi-chu-quan/index.vue'),
        name: Pages.managingUnit,
      },
      {
        path: '/nghe-sy',
        component: () => import('pages/nghe-sy/index.vue'),
        name: Pages.artist,
      },
      {
        path: '/nghe-sy/cap-nhat-thong-tin-nghe-sy/:id',
        component: () => import('pages/cap-nhat-thong-tin-nghe-sy/index.vue'),
        name: Pages.informationArtist,
      },
      {
        path: '/nghe-sy/them-nghe-sy',
        component: () => import('pages/them-nghe-sy/index.vue'),
        name: Pages.addArtist,
      },
      {
        path: '/khach-hang',
        component: () => import('pages/khach-hang/index.vue'),
        name: Pages.customer,
      },
    ],
  },

  // Always leave this as last one,
  // but you can also remove it
  {
    path: '/:catchAll(.*)*',
    component: () => import('pages/Error404.vue'),
  },
];

export default routes;
