import { defineComponent, Ref, ref, watch } from 'vue';
import { i18n } from 'src/boot/i18n';
import { Notify } from 'quasar';
import UploadImage from '../../upload-image/index.vue';

export default defineComponent({
  components: {
    UploadImage,
  },

  props: {
    openAddHotProduct: {
      type: Boolean,
      requied: true,
    },
  },

  setup(props, context) {
    const file: Ref<File | string> = ref('');
    const name: Ref<string> = ref('');
    const code: Ref<string> = ref('');
    const embeddedUrl: Ref<string> = ref('');
    const urlFileLocal: Ref<string> = ref('');
    const status: Ref<number> = ref(2);
    const statusOptions = ref([
      { id: 1, name: 'Sản phẩm khác' },
      { id: 2, name: 'Sản phẩm nổi bật' },
    ]);
    const uploadAvatar = (value: FileList) => {
      urlFileLocal.value = URL.createObjectURL(value[0]);
      file.value = value[0];
    };
    watch(
      () => props.openAddHotProduct,
      (value) => {
        if (value) {
          ResetData();
        }
      }
    );
    const ResetData = () => {
      file.value = '';
      code.value = '';
      name.value = '';
      embeddedUrl.value = '';
      urlFileLocal.value = '';
      status.value = 2;
    };
    const SubmitData = () => {
      context.emit('click:CloseBtnAddHotProduct');
      context.emit('insertData', {
        file: file.value,
        name: name.value,
        code: code.value,
        status: status.value,
        embeddedUrl: embeddedUrl.value,
        imageUrl: urlFileLocal.value,
      });
      Notify.create({
        type: 'positive',
        message: i18n.global.t(
          'artist.dialogLabel.validateMessages.addHotProductSccess'
        ),
        actions: [{ icon: 'close', color: 'white' }],
      });
    };

    const product_name = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireProducName'
        ),
    ];

    const product_code = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireProducCode'
        ),
    ];
    const url_embed = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireUrlembed'
        ),
    ];
    const statusRules = [
      (val?: number) =>
        val !== undefined ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireStatus'
        ),
    ];

    return {
      uploadAvatar,
      SubmitData,
      urlFileLocal,
      file,
      name,
      code,
      embeddedUrl,
      status,
      ResetData,
      product_name,
      product_code,
      url_embed,
      statusRules,
      statusOptions,
    };
  },

  emits: [
    'insertData',
    'update:openAddHotProduct',
    'update:statusHotProduct',
    'selectedFile',
    'click:CloseBtnAddHotProduct',
  ],
});
