import { defineComponent, PropType, Ref, ref, watch } from 'vue';
import { i18n } from 'src/boot/i18n';
import { isEmail } from '../../../boot/functions';
import { isMobilePhone } from '../../../boot/functions';
import { CustomerLevelType, CustomerType } from 'src/assets/type';

export default defineComponent({
  props: {
    showDialogUpdate: {
      type: Boolean,
      required: true,
    },
    levelOptions: {
      type: Array as PropType<CustomerLevelType[]>,
      required: true,
    },
    customerInfo: { type: Object as PropType<CustomerType>, required: true },
  },
  setup(props, context) {
    watch(
      () => props.showDialogUpdate,
      (value) => {
        if (value) {
          void getData();
        }
      }
    );
    const id: Ref<number | null> = ref(null);
    const code: Ref<string | null> = ref(null);
    const userName: Ref<string | null> = ref(null);
    const fullName: Ref<string | null> = ref(null);
    const companyName: Ref<string | null> = ref(null);
    const taxCode: Ref<string | null> = ref(null);
    const email: Ref<string | null> = ref(null);
    const status: Ref<number | null> = ref(1);
    const phone: Ref<string | null> = ref(null);
    const password: Ref<string | null> = ref(null);
    const address: Ref<string | null> = ref(null);
    const type: Ref<string | null> = ref(null);
    const representative: Ref<string | null> = ref(null);
    const position: Ref<string | null> = ref(null);
    const level: Ref<CustomerLevelType | null> = ref(null);

    const confirmEditCustomer = () => {
      context.emit('editCustomer', {
        id: id.value,
        code: code.value,
        userName: userName.value,
        fullName: fullName.value,
        companyName: companyName.value,
        taxCode: taxCode.value,
        email: email.value,
        status: status.value,
        phone: phone.value,
        password: password.value,
        address: address.value,
        type: type.value,
        representative: representative.value,
        position: position.value,
        level: level.value,
      });
    };
    const getData = () => {
      id.value = props.customerInfo.id;
      code.value = props.customerInfo.code;
      userName.value = props.customerInfo.userName;
      fullName.value = props.customerInfo.fullName;
      companyName.value = props.customerInfo.companyName;
      taxCode.value = props.customerInfo.taxCode;
      email.value = props.customerInfo.email;
      status.value = props.customerInfo.status;
      phone.value = props.customerInfo.phone;
      password.value = props.customerInfo.password;
      address.value = props.customerInfo.address;
      type.value = props.customerInfo.type;
      representative.value = props.customerInfo.representative;
      position.value = props.customerInfo.position;
      level.value = props.customerInfo.level;
    };
    const userNameRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('customer.validateMessages.requireUserName'),
    ];
    const passwordRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('customer.validateMessages.requirePassword'),
    ];
    const codeRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('customer.validateMessages.requireCode'),
    ];
    const customerNameRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('customer.validateMessages.requireCustomerName'),
    ];
    const businessNameRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('customer.validateMessages.requireBusinessName'),
    ];
    const taxCodeRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('customer.validateMessages.requireTaxCode'),
    ];
    const phoneRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('customer.validateMessages.requirePhone'),
      (val: string) =>
        isMobilePhone(val) ||
        i18n.global.t('customer.validateMessages.isPhone'),
    ];
    const emailRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('customer.validateMessages.requireEmail'),
      (val: string) =>
        isEmail(val) || i18n.global.t('customer.validateMessages.isEmail'),
    ];
    const addressRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('customer.validateMessages.requireAddress'),
    ];
    const businessTypeRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('customer.validateMessages.requireBusinessType'),
    ];
    const levelRules = [
      (val?: CustomerLevelType) =>
        val !== null ||
        i18n.global.t('customer.validateMessages.requireRatings'),
    ];
    const representativeRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('customer.validateMessages.requireRepresentative'),
    ];
    const positionRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t('customer.validateMessages.requiredPosition'),
    ];
    return {
      isPwd: ref(true),
      userNameRules,
      customerNameRules,
      businessNameRules,
      passwordRules,
      codeRules,
      taxCodeRules,
      emailRules,
      levelRules,
      addressRules,
      businessTypeRules,
      representativeRules,
      positionRules,
      phoneRules,
      userName,
      fullName,
      companyName,
      taxCode,
      email,
      status,
      phone,
      password,
      address,
      type,
      representative,
      position,
      level,
      code,
      confirmEditCustomer,
      id,
    };
  },
  emits: ['update:showDialogUpdate', 'click:CloseBtn', 'editCustomer'],
});
