import { defineComponent, PropType, Ref, ref, watch } from 'vue';
import { PaginationResponse, PostType } from 'src/assets/type';
import { i18n } from 'src/boot/i18n';
import { API_PATHS, config } from 'src/assets/configurations.example';
import { api, BaseResponseBody } from 'src/boot/axios';
import { AxiosResponse } from 'axios';
import Pagination from 'components/pagination/index.vue';
export default defineComponent({
  components: {
    Pagination,
  },
  props: {
    isOpenListPost: { type: Boolean, required: true },
    postSelected: { type: Array as PropType<PostType[]>, required: true },
  },
  setup(props) {
    watch(
      () => props.isOpenListPost,
      (value) => {
        if (value) {
          void getListPosts();
          selected.value = props.postSelected;
        }
      }
    );
    const keywordSearch: Ref<string | null> = ref(null);
    const userTableRowsPost: Ref<PostType[]> = ref([]);
    const userTableColumnsPost = [
      {
        name: 'stt',
        field: 'stt',
        required: true,
        label: i18n.global.t('postCategory.tableColumnsPost.stt'),
        align: 'center',
        sortable: false,
      },
      {
        name: 'name',
        field: 'name',
        required: true,
        label: i18n.global.t('postCategory.tableColumnsPost.name'),
        align: 'center',
        headerStyle: 'text-align: center !important;',
        sortable: false,
      },
      {
        name: 'image',
        field: 'image',
        required: true,
        label: i18n.global.t('postCategory.tableColumnsPost.imageMini'),
        headerStyle: 'text-align: center !important;',
        align: 'left',
        sortable: false,
      },
    ];
    const pageIndex = ref(1);
    const pageSize = ref(20);
    const totalPage = ref(1);
    const configImg = config;
    const selected: Ref<PostType[]> = ref([]);
    const getListPosts = async () => {
      const response = (await api({
        url: API_PATHS.getListPost,
        method: 'GET',
        params: {
          pageIndex: pageIndex.value,
          pageSize: pageSize.value,
          name: keywordSearch.value,
          // langId: 1,
        },
      })) as AxiosResponse<BaseResponseBody<PaginationResponse<PostType>>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        userTableRowsPost.value = response.data.data.data;
        totalPage.value = response.data.data.totalPages;
      }
    };
    const changePageSize = () => {
      pageIndex.value = 1;
      void getListPosts();
    };
    const getSelectedString = () => {
      return selected.value.length === 0
        ? ''
        : `${selected.value.length} bài viết đã được chọn `;
    };
    return {
      keywordSearch,
      userTableRowsPost,
      userTableColumnsPost,
      pageIndex,
      pageSize,
      totalPage,
      configImg,
      selected,
      getListPosts,
      changePageSize,
      getSelectedString,
    };
  },
  emits: ['update:isOpenListPost', 'click:closeBtnDialog', 'submitData'],
});
