import { defineComponent, Ref, ref, watch } from 'vue';
import { i18n } from 'src/boot/i18n';
// import { isEmail } from '../../../boot/functions';
// import { isMobilePhone } from '../../../boot/functions';
import UploadImage from '../../upload-image/index.vue';

export default defineComponent({
  components: {
    UploadImage,
  },

  props: {
    openAddHotProduct: {
      type: Boolean,
      requied: true,
    },
  },

  setup(props, context) {
    const file: Ref<File | string> = ref('');
    const code: Ref<string> = ref('');
    const embeddedUrl: Ref<string> = ref('');
    const urlFileLocal: Ref<string> = ref('');
    const status: Ref<number> = ref(2);
    const uploadAvatar = (value: FileList) => {
      urlFileLocal.value = URL.createObjectURL(value[0]);
      file.value = value[0];
    };
    watch(
      () => props.openAddHotProduct,
      (value) => {
        if (value) {
          ResetData();
        }
      }
    );
    const ResetData = () => {
      file.value = '';
      code.value = '';
      embeddedUrl.value = '';
      urlFileLocal.value = '';
      status.value = 2;
    };
    const SubmitData = () => {
      context.emit('click:CloseBtnAddHotProduct');
      context.emit('insertData', {
        file: file.value,
        code: code.value,
        status: status.value,
        embeddedUrl: embeddedUrl.value,
        imageUrl: urlFileLocal.value,
      });
    };
    const product_code = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireProducCode'
        ),
    ];
    const url_embed = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireUrlembed'
        ),
    ];

    return {
      uploadAvatar,
      SubmitData,
      urlFileLocal,
      file,
      code,
      embeddedUrl,
      status,
      ResetData,
      product_code,
      url_embed,
    };
  },

  emits: [
    'insertData',
    'update:openAddHotProduct',
    'update:statusHotProduct',
    'selectedFile',
    'click:CloseBtnAddHotProduct',
  ],
});
