import { defineComponent, PropType, Ref, ref, watch } from 'vue';
import { i18n } from 'src/boot/i18n';
// import { isEmail } from '../../../boot/functions';
// import { isMobilePhone } from '../../../boot/functions';
import UploadImage from '../../upload-image/index.vue';
import { ProductType } from 'src/assets/type';

export default defineComponent({
  components: {
    UploadImage,
  },

  props: {
    openUpdateHotProduct: {
      type: Boolean,
      requied: true,
    },
    dataUpdate: {
      type: Object as PropType<ProductType>,
      requied: false,
    },
  },

  setup(props, context) {
    const file: Ref<File | string> = ref('');
    const code: Ref<string> = ref('');
    const embeddedUrl: Ref<string> = ref('');
    const urlFileLocal: Ref<string> = ref('');
    const status: Ref<number> = ref(2);
    const id: Ref<number | null> = ref(null);
    const uploadAvatar = (value: FileList) => {
      urlFileLocal.value = URL.createObjectURL(value[0]);
      file.value = value[0];
    };
    watch(
      () => props.openUpdateHotProduct,
      (value) => {
        if (value) {
          id.value = props.dataUpdate?.id as number;
          code.value = props.dataUpdate?.code as string;
          embeddedUrl.value = props.dataUpdate?.embeddedUrl as string;
          status.value = props.dataUpdate?.status as number;
          urlFileLocal.value = props.dataUpdate?.imageUrl as string;
        }
      }
    );
    const ResetData = () => {
      file.value = '';
      code.value = '';
      embeddedUrl.value = '';
      urlFileLocal.value = '';
      status.value = 2;
    };
    const SubbmitDataUpdate = () => {
      context.emit('click:CloseBtnUpdateHotProduct');
      context.emit('UpdateData', {
        file: file.value,
        code: code.value,
        status: status.value,
        embeddedUrl: embeddedUrl.value,
        imageUrl: urlFileLocal.value,
        id:id.value
      });
    };
    const product_code = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireProducCode'
        ),
    ];
    const url_embed = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireUrlembed'
        ),
    ];

    return {
      uploadAvatar,
      SubbmitDataUpdate,
      urlFileLocal,
      file,
      code,
      embeddedUrl,
      status,
      ResetData,
      product_code,
      url_embed,
      id,
    };
  },

  emits: [
    'UpdateData',
    'update:statusHotProduct',
    'selectedFile',
    'click:CloseBtnUpdateHotProduct',
    'update:openUpadateHotProduct',
  ],
});
