import { defineComponent, PropType, ref, watch } from 'vue';
import { i18n } from 'src/boot/i18n';
import { useRouter } from 'vue-router';
import { BannerType, StoriesType } from 'src/assets/type';
import UploadImage from 'components/upload-image/index.vue';
import { Dialog } from 'quasar';

export default defineComponent({
  components: { UploadImage },

  props: {
    id: { number: String, required: true },
    account: { type: String, required: true },
    banners: { type: Array as PropType<BannerType[]>, required: true },
    shortDescription: { type: Array, required: true },
    socialEmbedded: { type: Array, required: true },
    stories: { type: Array as PropType<StoriesType[]>, required: true },
    formatSchedules: { type: Array as PropType<string[]>, required: true },
  },

  setup(props, context) {
    const router = useRouter();
    watch(
      () => props.banners.length,
      (value) => {
        slide.value = value - 1;
      }
    );
    watch(
      () => props.stories.length,
      (value) => {
        slideStory.value = value - 1;
      }
    );
    const slide = ref(0);
    const slideStory = ref(0);
    const editor = ref('Customize it.');
    const accountRules = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireFullName'
        ),
    ];
    const uploadBanner = (value: FileList) => {
      context.emit('selectedFile', encodeImageFileAsURL(value[0]));
    };
    const encodeImageFileAsURL = (file: File) => {
      return { url: URL.createObjectURL(file), file: file };
    };
    const deleteImage = (index: number) => {
      Dialog.create({
        title: i18n.global.t(
          'managingUnit.confirmActionsTitle.confirmDeleteManagingUnitsTitle'
        ),
        message: i18n.global.t(
          'managingUnit.confirmActionsTitle.confirmDeleteManagingUnitsContent'
        ),
        cancel: i18n.global.t(
          'managingUnit.confirmActionsTitle.confirmDeleteManagingUnitsCancelBtnLabel'
        ),
        color: 'negative',
      }).onOk(() => {
        context.emit('deleteBanner', index);
      });
    };
    const deleteStory = (storyIdx: number) => {
      context.emit('confirmDeleteStory', storyIdx);
    };

    return {
      router,
      slide,
      slideStory,
      editor,
      accountRules,
      uploadBanner,
      deleteImage,
      deleteStory,
    };
  },
  emits: [
    'update:account',
    'update:shortDescription',
    'update:content',
    'update:formatSchedules',
    'selectedFile',
    'deleteBanner',
    'openDialogUploadEmbed',
    'deleteImagesStories',
    'deleteStories',
    'confirmDeleteSocialEmbedded',
    'click:openAddStoryDialog',
    'confirmDeleteStory',
  ],
});
