import { defineComponent, ref, Ref } from 'vue';
import { i18n } from 'src/boot/i18n';
import UploadImage from '../../upload-image/index.vue';
import moment from 'moment';
export default defineComponent({
  props: {
    id: { type: Number, required: true },
    artistCode: { type: String, required: true },
    avatar: { type: String, required: true },
    fullName: { type: String, required: true },
    artistName: { type: String, required: true },
    birthday: { type: String, required: true },
    sex: { type: Number, required: true },
    nationality: { type: Number, required: true },
    status: { type: Number, required: true },
    address: { type: String, required: true },
    fields: { type: Array, required: true },
    works: { type: Number, required: true },
    qualification: { type: Number, required: true },
    artistLevel: { type: Number, required: true },
    phoneNumber: { type: String, required: true },
    email: { type: String, required: true },
    facebook: { type: String, required: true },
    facebookMessage: { type: String, required: true },
    instagram: { type: String, required: true },
    whatsapp: { type: String, required: true },
    sexOptions: { type: Array, required: true },
    fieldOptions: { type: Array, required: true },
    nationalityOptions: { type: Array, required: true },
    professionOptions: { type: Array, required: true },
    artistLevelOptions: { type: Array, required: true },
    workOptions: { type: Array, required: true },
    artistCodeRules: { type: Boolean, required: true },
    fullNameRules: { type: Boolean, required: true },
    artistNameRules: { type: Boolean, required: true },
    birthdayRules: { type: Boolean, required: true },
    emailRules: { type: Boolean, required: true },
    addressRules: { type: Boolean, required: true },
    phoneNumberRules: { type: Boolean, required: true },
    sexRules: { type: Boolean, required: true },
    nationalityRules: { type: Boolean, required: true },
    fieldRules: { type: Boolean, required: true },
    workRules: { type: Boolean, required: true },
    qualificationRules: { type: Boolean, required: true },
    artistLevelRules: { type: Boolean, required: true },
    errorMessPhoneNumber: { type: String, required: true },
    errorMessEmail: { type: String, required: true },
  },
  components: {
    UploadImage,
  },
  setup(_, context) {
    const BirthdayDatePicker = ref(moment().format('YYYY/MM/DD'));
    const selectedFile = (value: FileList) => {
      // console.log(value);
      // console.log(URL.createObjectURL(value[0]));
      context.emit('SetAvatar', {
        file: value[0],
        url: URL.createObjectURL(value[0]),
      });
    };

    const upload = ref(null);
    const uploadBanner = () => {
      // eslint-disable-next-line
      // @ts-ignore
      // eslint-disable-next-line
      upload.value?.click();
    };
    const deleteAvatar = () => {
      console.log('object');
      context.emit('deleteAvatar');
    };
    const selectDatePicker = (value: string) => {
      context.emit('UpdateBirtday', formatDatePicker(value));
    };
    const formatDatePicker = (value: string) => {
      return moment(value).format('DD/MM/YYYY');
    };
    const openDialog: Ref<boolean> = ref(false);
    const onOKClick = () => {
      // console.log(BirthdayDatePicker.value);
      selectDatePicker(BirthdayDatePicker.value);
      openDialog.value = false;
    };
    // const onOKClick = () => {};
    const onCancelClick = () => {
      openDialog.value = false;
    };

    const errorMessArtistCode = i18n.global.t(
      'artist.artistInformation.validateMessages.requireArtistCode'
    );
    const errorMessFullName = i18n.global.t(
      'artist.artistInformation.validateMessages.requireFullName'
    );
    const errorMessArtistName = i18n.global.t(
      'artist.artistInformation.validateMessages.requireArtistName'
    );
    const errorMessBirthday = i18n.global.t(
      'artist.artistInformation.validateMessages.requireBirthday'
    );
    const errorMessSex = i18n.global.t(
      'artist.artistInformation.validateMessages.requireSex'
    );
    const errorMessNationality = i18n.global.t(
      'artist.artistInformation.validateMessages.requireNationality'
    );
    const errorMessAddress = i18n.global.t(
      'artist.artistInformation.validateMessages.requireAddress'
    );
    const errorMessFields = i18n.global.t(
      'artist.artistInformation.validateMessages.requireField'
    );
    const errorMessWorks = i18n.global.t(
      'artist.artistInformation.validateMessages.requiredWork'
    );
    const errorMessQualification = i18n.global.t(
      'artist.artistInformation.validateMessages.requireQualification'
    );
    const errorMessArtistLevel = i18n.global.t(
      'artist.artistInformation.validateMessages.requireArtistLevel'
    );

    return {
      upload,
      uploadBanner,
      selectedFile,
      deleteAvatar,
      BirthdayDatePicker,
      selectDatePicker,
      formatDatePicker,
      openDialog,
      onOKClick,
      onCancelClick,
      errorMessArtistCode,
      errorMessFullName,
      errorMessArtistName,
      errorMessBirthday,
      errorMessSex,
      errorMessNationality,
      errorMessAddress,
      errorMessFields,
      errorMessWorks,
      errorMessQualification,
      errorMessArtistLevel,
    };
  },
  emits: [
    'update:artistCode',
    'update:fullName',
    'update:avatar',
    'update:artistName',
    'update:birthday',
    'update:email',
    'update:facebook',
    'update:facebookMessage',
    'update:instagram',
    'update:whatsapp',
    'update:address',
    'update:phoneNumber',
    'update:sex',
    'update:nationality',
    'update:fields',
    'update:works',
    'update:qualification',
    'update:artistLevel',
    'update:status',
    'addNewArtist',
    'SetAvatar',
    'deleteAvatar',
    'UpdateBirtday',
  ],
});
