import { defineComponent, Ref, ref, watch } from 'vue';
export default defineComponent({
  // name: 'ComponentName'
  props: {
    isOpenDialogEmbed: {
      type: Boolean,
      required: true,
    },
    socialEmbedded: { type: String, required: true },
  },
  setup(props, context) {
    watch(
      () => props.isOpenDialogEmbed,
      (value) => {
        if (value) {
          newSocialEmbed.value = props.socialEmbedded;
        }
      }
    );
    const newSocialEmbed: Ref<string | null> = ref(null);
    const confirmEditEmbed = () => {
      context.emit('uploadEmbed', newSocialEmbed.value);
    };
    return { newSocialEmbed, confirmEditEmbed };
  },
  emits: [
    'update:isOpenDialogEmbed',
    'click:CloseBtn',
    'update:socialEmbedded',
    'uploadEmbed',
  ],
});
