import { defineComponent, onMounted, ref, Ref, watch } from 'vue';
import { api, BaseResponseBody } from 'src/boot/axios';
import { API_PATHS, config } from 'src/assets/configurations';
import { useRoute } from 'vue-router';
import { AxiosResponse } from 'axios';
import moment from 'moment';
import { i18n } from 'src/boot/i18n';
import { Dialog, Notify } from 'quasar';
import { Router } from 'src/router';
import { Pages } from 'src/router/routes';

import PersonalInformation from 'components/artist-information/personal-information/index.vue';
import VabAccount from 'components/artist-information/VAB-account/index.vue';
import BankAccount from 'components/artist-information/bank-account/index.vue';
import HotProduct from 'components/artist-information/hot-product/index.vue';
import AddHotProductDialog from 'components/artist-information/AddHotProduct/index.vue';
import AddNewBankAccountDialog from 'components/artist-information/bank-account/add-new-bank-account-dialog/index.vue';
import EditBankAccountDialog from 'components/artist-information/bank-account/edit-bank-account/index.vue';
import UploadEmbedDialog from 'components/artist-information/upload-embed-dialog/index.vue';
import UpdateHotProduct from 'components/artist-information/UpdateHotProduct/index.vue';
import AddStory from 'components/artist-information/VAB-account/add-story/index.vue';

import {
  ArtistInfoType,
  FieldType,
  NationalityType,
  ArtistLevelType,
  QualificationType,
  WorkType,
  BankAccountType,
  ProductType,
  BannerType,
  StoriesType,
  SchedulesType,
  CardBankType,
  TypeCardType,
  FileUploadType,
} from 'src/assets/type';
import { isEmail } from '../../boot/functions';
import { isMobilePhone } from '../../boot/functions';

export type AvatarType = {
  file?: File;
  url?: string | null;
};
export default defineComponent({
  components: {
    PersonalInformation,
    VabAccount,
    BankAccount,
    HotProduct,
    AddNewBankAccountDialog,
    EditBankAccountDialog,
    AddHotProductDialog,
    UpdateHotProduct,
    UploadEmbedDialog,
    AddStory,
  },

  setup() {
    const route = useRoute();
    const tab = ref('information');

    // state open dialog
    const isOpenAddAccountBankDialog: Ref<boolean> = ref(false);
    const isOpenEditAccountBankDialog: Ref<boolean> = ref(false);
    const openAddHotProduct: Ref<boolean> = ref(false);
    const openUpdateHotProduct: Ref<boolean> = ref(false);
    const isOpenDialogEmbed: Ref<boolean> = ref(false);
    const isOpenAddStory: Ref<boolean> = ref(false);

    // state
    const fieldOptions: Ref<FieldType[]> = ref([]);
    const nationalityOptions: Ref<NationalityType[]> = ref([]);
    const professionOptions: Ref<QualificationType[]> = ref([]);
    const artistLevelOptions: Ref<ArtistLevelType[]> = ref([]);
    const cardBankOptions: Ref<CardBankType[]> = ref([]);
    const typeBankOptions: Ref<TypeCardType[]> = ref([]);
    const workOptions: Ref<WorkType[]> = ref([]);
    const sexOptions = ref([
      { id: 1, name: 'Nam' },
      { id: 2, name: 'Nữ' },
    ]);

    //state sử dụng trong tab thong-tin-ca-nhan
    const id: Ref<number> = ref(0);
    const account: Ref<string | null> = ref(null);
    const avatar: Ref<string | null> = ref(null);
    const avatarFile: Ref<File | null> = ref(null);
    const avatarUploaded: Ref<string | null> = ref(null);
    const artistCode: Ref<string> = ref('');
    const fullName: Ref<string> = ref('');
    const artistName: Ref<string | null> = ref(null);
    const birthday: Ref<string | null> = ref(null);
    const sex: Ref<number | null> = ref(null);
    const nationality: Ref<NationalityType | null> = ref(null);
    const qualification: Ref<QualificationType | null> = ref(null);
    const artistLevel: Ref<ArtistLevelType | null> = ref(null);
    const address: Ref<string | null> = ref(null);
    const status: Ref<number> = ref(1);
    const fields: Ref<FieldType[]> = ref([]);
    const works: Ref<WorkType[]> = ref([]);
    const phoneNumber: Ref<string | null> = ref(null);
    const email: Ref<string | null> = ref(null);
    const facebook: Ref<string | null> = ref(null);
    const facebookMessage: Ref<string | null | undefined> = ref();
    const instagram: Ref<string | null | undefined> = ref();
    const whatsapp: Ref<string | null | undefined> = ref();

    // state sử dụng trong tab vab account
    const banners: Ref<BannerType[]> = ref([]);
    const shortDescription: Ref<string | null> = ref('');
    const socialEmbedded: Ref<string | null> = ref(null);
    const stories: Ref<StoriesType[]> = ref([]);
    const schedules: Ref<SchedulesType[]> = ref([]);
    const formatSchedules: Ref<string[]> = ref([]);

    //state accountBank
    const bankAccounts: Ref<BankAccountType[]> = ref([]);
    const rowBankAccIdx: Ref<number> = ref(0);
    const rowDataAccBank: Ref<BankAccountType | null> = ref(null);

    //state hot product
    const products: Ref<ProductType[]> = ref([]);
    const statusHotProduct: Ref<number> = ref(2);
    const DataInsertHotProduct: Ref<ProductType | null> = ref(null);
    const DataUpdateHotProduct: Ref<ProductType | null> = ref(null);

    //sate error input thong-tin-ca-nhan
    const artistCodeRules = ref(false);
    const fullNameRules = ref(false);
    const artistNameRules = ref(false);
    const birthdayRules = ref(false);
    const emailRules = ref(false);
    const addressRules = ref(false);
    const phoneNumberRules = ref(false);
    const sexRules = ref(false);
    const nationalityRules = ref(false);
    const fieldRules = ref(false);
    const workRules = ref(false);
    const qualificationRules = ref(false);
    const artistLevelRules = ref(false);
    const errorMessEmail = ref(
      i18n.global.t('artist.artistInformation.validateMessages.requireEmail')
    );
    const errorMessPhoneNumber = ref(
      i18n.global.t(
        'artist.artistInformation.validateMessages.requirePhoneNumber'
      )
    );
    watch(
      () => artistCode.value,
      (value) => {
        if (value) {
          artistCodeRules.value = false;
        }
      }
    );
    watch(
      () => fullName.value,
      (value) => {
        if (value) {
          fullNameRules.value = false;
        }
      }
    );
    watch(
      () => artistName.value,
      (value) => {
        if (value) {
          artistNameRules.value = false;
        }
      }
    );
    watch(
      () => birthday.value,
      (value) => {
        if (value) {
          birthdayRules.value = false;
        }
      }
    );
    watch(
      () => email.value,
      (value) => {
        if (value) {
          emailRules.value = false;
        }
      }
    );
    watch(
      () => address.value,
      (value) => {
        if (value) {
          addressRules.value = false;
        }
      }
    );
    watch(
      () => phoneNumber.value,
      (value) => {
        if (value) {
          phoneNumberRules.value = false;
        }
      }
    );
    watch(
      () => sex.value,
      (value) => {
        if (value) {
          sexRules.value = false;
        }
      }
    );
    watch(
      () => nationality.value,
      (value) => {
        if (value) {
          nationalityRules.value = false;
        }
      }
    );
    watch(
      () => fields.value,
      (value) => {
        if (value) {
          fieldRules.value = false;
        }
      }
    );
    watch(
      () => works.value,
      (value) => {
        if (value) {
          workRules.value = false;
        }
      }
    );
    watch(
      () => qualification.value,
      (value) => {
        if (value) {
          qualificationRules.value = false;
        }
      }
    );
    watch(
      () => artistLevel.value,
      (value) => {
        if (value) {
          artistLevelRules.value = false;
        }
      }
    );

    const getInformationArtist = async () => {
      const response = (await api({
        url: API_PATHS.getDetailArtist,
        method: 'GET',
        params: { artistId: route.params.id },
      })) as AxiosResponse<BaseResponseBody<ArtistInfoType>>;
      console.log(response, 'Artist Detail Info');
      const ArtistInformation = response.data.data;
      id.value = ArtistInformation.id;
      avatar.value = ArtistInformation.avatar;
      account.value = ArtistInformation.account;
      artistCode.value = ArtistInformation.artistCode;
      fullName.value = ArtistInformation.fullName;
      artistName.value = ArtistInformation.artistName;
      birthday.value = moment(
        ArtistInformation.birthday,
        'DD/MM/YYYY HH:mm:ss'
      ).format('DD/MM/YYYY');
      address.value = ArtistInformation.address;
      status.value = ArtistInformation.status;
      phoneNumber.value = ArtistInformation.phoneNumber;
      email.value = ArtistInformation.email;
      facebook.value = ArtistInformation.facebook;
      facebookMessage.value = ArtistInformation.facebookMessage;
      instagram.value = ArtistInformation.instagram;
      whatsapp.value = ArtistInformation.whatsapp;
      nationality.value = ArtistInformation.nationality;
      qualification.value = ArtistInformation.qualification;
      works.value = ArtistInformation.works;
      artistLevel.value = ArtistInformation.artistLevel;
      sex.value = ArtistInformation.sex;
      fields.value = ArtistInformation.fields;
      bankAccounts.value = ArtistInformation.bankAccounts;
      products.value = ArtistInformation.products;
      banners.value = ArtistInformation.banners || [];
      socialEmbedded.value = ArtistInformation.socialEmbedded;
      stories.value = ArtistInformation.stories;
      schedules.value = ArtistInformation.schedules;
      for (let index = 0; index < schedules.value.length; index++) {
        const element = schedules.value[index];
        formatSchedules.value.push(
          moment(element.scheduleTime, 'DD/MM/YYYY HH:mm:ss').format(
            'YYYY/MM/DD'
          )
        );
      }
    };

    const getFieldOptions = async () => {
      const response = (await api({
        url: API_PATHS.getFieldOptions,
        method: 'GET',
        params: {},
      })) as AxiosResponse<BaseResponseBody<FieldType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        fieldOptions.value = response.data.data;
        console.log(fieldOptions.value, 'fieldOptions');
      }
    };

    const getNationalityOptions = async () => {
      const response = (await api({
        url: API_PATHS.getNationalityOptions,
        method: 'GET',
        params: {},
      })) as AxiosResponse<BaseResponseBody<NationalityType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        nationalityOptions.value = response.data.data;
      }
    };
    const getArtistLevelOptions = async () => {
      const response = (await api({
        url: API_PATHS.getArtistLevelOptions,
        method: 'GET',
        params: {},
      })) as AxiosResponse<BaseResponseBody<ArtistLevelType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        artistLevelOptions.value = response.data.data;
      }
    };
    const getQualificationOptions = async () => {
      const response = (await api({
        url: API_PATHS.getQualificationOptions,
        method: 'GET',
        params: {},
      })) as AxiosResponse<BaseResponseBody<QualificationType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        professionOptions.value = response.data.data;
      }
    };
    const getWorkOptions = async () => {
      const response = (await api({
        url: API_PATHS.getWorkOptions,
        method: 'GET',
        params: {
          // fieldId: fields.value[0].id,
        },
      })) as AxiosResponse<BaseResponseBody<WorkType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        workOptions.value = response.data.data;
      }
    };
    const getBankOptions = async () => {
      const response = (await api({
        url: API_PATHS.bankOptions,
        method: 'GET',
        params: {},
      })) as AxiosResponse<BaseResponseBody<CardBankType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        cardBankOptions.value = response.data.data;
      }
    };
    const getTypeCardOptions = async () => {
      const response = (await api({
        url: API_PATHS.cardTypeOptions,
        method: 'GET',
        params: {},
      })) as AxiosResponse<BaseResponseBody<TypeCardType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        typeBankOptions.value = response.data.data;
      }
    };

    const addAccBank = (item: BankAccountType) => {
      if (item.isDefault === 1) {
        bankAccounts.value.forEach((element) => (element.isDefault = 2));
        bankAccounts.value.push(item);
        isOpenAddAccountBankDialog.value = false;
      } else {
        bankAccounts.value.push(item);
        isOpenAddAccountBankDialog.value = false;
      }
    };
    const editAccBank = (item: BankAccountType) => {
      if (item.isDefault === 1) {
        bankAccounts.value.forEach((element) => (element.isDefault = 2));
        bankAccounts.value[rowBankAccIdx.value] = item;
        isOpenEditAccountBankDialog.value = false;
      } else {
        bankAccounts.value[rowBankAccIdx.value] = item;
        isOpenEditAccountBankDialog.value = false;
      }
    };
    const confirmDeleteAccBank = (value: number) => {
      Dialog.create({
        title: i18n.global.t(
          'artist.bankAccount.confirmActionsTitle.confirmDeleteAccBankTitle'
        ),
        message: i18n.global.t(
          'artist.bankAccount.confirmActionsTitle.confirmDeleteAccBankContent'
        ),
        cancel: i18n.global.t(
          'artist.bankAccount.confirmActionsTitle.confirmDeleteAccBankBtnLabel'
        ),
        color: 'negative',
      }).onOk(() => {
        Notify.create({
          type: 'positive',
          message: i18n.global.t(
            'artist.dialogLabel.validateMessages.deleteAccess'
          ),
        });
        bankAccounts.value.splice(value, 1);
      });
    };
    const openDialogEditAccBank = (
      itemData: BankAccountType,
      itemIdx: number
    ) => {
      console.log(itemData, 'rowData');
      rowDataAccBank.value = itemData;
      rowBankAccIdx.value = itemIdx;
      console.log(rowBankAccIdx.value);

      isOpenEditAccountBankDialog.value = true;
    };

    const pushData = (value: ProductType) => {
      products.value.push(value);
    };

    const selectedFile = (value: BannerType) => {
      console.log(value, 'banners');

      banners.value.push(value);
      console.log(banners.value);
    };
    const reset = ref(null);
    const resetOldData = () => {
      document.getElementById('reset')?.click();
    };
    const confirmDeleteRow = (value: number) => {
      Dialog.create({
        title: i18n.global.t(
          'artist.bankAccount.confirmActionsTitle.confirmDeleteAccBankTitle'
        ),
        message: i18n.global.t(
          'artist.bankAccount.confirmActionsTitle.confirmDeleteAccBankContent'
        ),
        cancel: i18n.global.t(
          'artist.bankAccount.confirmActionsTitle.confirmDeleteAccBankBtnLabel'
        ),
        color: 'negative',
      }).onOk(() => {
        products.value.splice(value, 1);
      });
    };
    const UpdateData = (value: ProductType) => {
      for (let i = 0; i < products.value.length; i++) {
        if (products.value[i].id === value?.id) {
          products.value[i] = value;
        }
      }
    };
    const SetProduct = (value: ProductType) => {
      DataUpdateHotProduct.value = value;
    };
    const setAvatar = (value: BannerType) => {
      console.log(value, 'avatarFile');
      avatarFile.value = value.file as File;
      avatar.value = value.url as string;
    };

    const confirmDeleteSocialEmbedded = () => {
      Dialog.create({
        title: i18n.global.t(
          'artist.bankAccount.confirmActionsTitle.confirmDeleteAccBankTitle'
        ),
        message: i18n.global.t(
          'artist.confirmActionsTitle.confirmDeleteEmbedContent'
        ),
        cancel: i18n.global.t(
          'artist.bankAccount.confirmActionsTitle.confirmDeleteAccBankBtnLabel'
        ),
        color: 'negative',
      }).onOk(() => {
        socialEmbedded.value = null;
      });
    };

    const changeEmbed = (newEmbed: string | null) => {
      socialEmbedded.value = newEmbed;
      console.log(newEmbed, 'newEmbed');

      isOpenDialogEmbed.value = false;
    };

    const addStory = (value: StoriesType) => {
      stories.value.push(value);
      console.log(stories, 'storiesstoriesstories');
    };

    const deleteStory = (idx: number) => {
      Dialog.create({
        title: i18n.global.t(
          'artist.bankAccount.confirmActionsTitle.confirmDeleteAccBankTitle'
        ),
        message: i18n.global.t(
          'artist.vabAccount.confirmActionsTitle.confirmDeleteStory'
        ),
        cancel: i18n.global.t(
          'artist.bankAccount.confirmActionsTitle.confirmDeleteAccBankBtnLabel'
        ),
        color: 'negative',
      }).onOk(() => {
        Notify.create({
          type: 'positive',
          message: i18n.global.t(
            'artist.dialogLabel.validateMessages.deleteStoryAccess'
          ),
        });
        stories.value.splice(idx, 1);
      });
    };
    const UpdateBirtday = (value: string) => {
      // console.log(value);
      console.log(value, 'birthdayyyy');

      birthday.value = value;
    };
    const callApiUploadAvatar = async (file: File) => {
      try {
        const bodyFormData = new FormData();
        bodyFormData.append('file', file);
        const response = (await api({
          headers: { 'Content-Type': 'multipart/form-data' },
          url: 'http://cms.vab.xteldev.com/file/upload',
          method: 'POST',
          data: bodyFormData,
        })) as AxiosResponse<BaseResponseBody<FileUploadType>>;
        if (response.data.error.code === config.API_RES_CODE.OK.code) {
          avatarUploaded.value =
            'http://cms.vab.xteldev.com/file/upload/' +
            response.data.data.fileName;
        }
      } catch (error) {}
    };
    const callApiUploadBanners = async (file: File, index: number) => {
      try {
        const bodyFormData = new FormData();
        bodyFormData.append('file', file);
        const response = (await api({
          headers: { 'Content-Type': 'multipart/form-data' },
          url: 'http://cms.vab.xteldev.com/file/upload',
          method: 'POST',
          data: bodyFormData,
        })) as AxiosResponse<BaseResponseBody<FileUploadType>>;
        if (response.data.error.code === config.API_RES_CODE.OK.code) {
          const bannerUpload =
            'http://cms.vab.xteldev.com/file/upload/' +
            response.data.data.fileName;
          banners.value[index] = {
            bannerUrl: bannerUpload,
          };
        }
      } catch (error) {}
    };
    const callApiUploadStories = async (file: File, idxStory: number) => {
      try {
        const bodyFormData = new FormData();
        bodyFormData.append('file', file);
        const response = (await api({
          headers: { 'Content-Type': 'multipart/form-data' },
          url: 'http://cms.vab.xteldev.com/file/upload',
          method: 'POST',
          data: bodyFormData,
        })) as AxiosResponse<BaseResponseBody<FileUploadType>>;
        if (response.data.error.code === config.API_RES_CODE.OK.code) {
          const urlStoryUpload =
            'http://cms.vab.xteldev.com/file/upload/' +
            response.data.data.fileName;
          stories.value[idxStory].imageUrl = urlStoryUpload;
        }
      } catch (error) {}
    };
    const checkValidate = () => {
      let hasError = false;
      if (!artistCode.value || !artistCode.value?.trim().length) {
        hasError = true;
        artistCodeRules.value = true;
      }
      if (!fullName.value || !fullName.value?.trim().length) {
        hasError = true;
        fullNameRules.value = true;
      }
      if (!artistName.value || !artistName.value?.trim().length) {
        hasError = true;
        artistNameRules.value = true;
      }
      if (!address.value || !address.value.trim().length) {
        hasError = true;
        addressRules.value = true;
      }
      if (!birthday.value || !birthday.value?.trim().length) {
        hasError = true;
        birthdayRules.value = true;
      }
      if (sex.value === null) {
        hasError = true;
        sexRules.value = true;
      }
      if (!phoneNumber.value || !phoneNumber.value?.trim().length) {
        hasError = true;
        phoneNumberRules.value = true;
        errorMessPhoneNumber.value = i18n.global.t(
          'artist.artistInformation.validateMessages.requirePhoneNumber'
        );
      }

      if (!isMobilePhone(phoneNumber.value as string)) {
        hasError = true;
        phoneNumberRules.value = true;
        errorMessPhoneNumber.value = i18n.global.t(
          'artist.artistInformation.validateMessages.isPhone'
        );
      }
      if (!email.value || !email.value?.trim().length) {
        hasError = true;
        emailRules.value = true;
        errorMessEmail.value = i18n.global.t(
          'artist.artistInformation.validateMessages.requireEmail'
        );
      }
      if (!isEmail(email.value as string)) {
        hasError = true;
        emailRules.value = true;
        errorMessEmail.value = i18n.global.t(
          'artist.artistInformation.validateMessages.isEmail'
        );
      }

      if (artistLevel.value === null) {
        hasError = true;
        artistLevelRules.value = true;
      }
      if (!fields.value.length) {
        hasError = true;
        fieldRules.value = true;
      }
      if (nationality.value === null) {
        hasError = true;
        nationalityRules.value = true;
      }
      if (qualification.value === null) {
        hasError = true;
        qualificationRules.value = true;
      }
      if (!works.value.length) {
        hasError = true;
        workRules.value = true;
      }
      if (hasError === false) {
        void updateInformationArtist();
      }
    };
    const updateInformationArtist = async () => {
      try {
        if (avatarFile.value !== null) {
          await callApiUploadAvatar(avatarFile.value);
        } else avatarUploaded.value = avatar.value;
        for (let index = 0; index < banners.value.length; index++) {
          const element = banners.value[index];
          if (element.file !== undefined) {
            await callApiUploadBanners(element.file, index);
          }
        }
        for (let idx = 0; idx < stories.value.length; idx++) {
          const item = stories.value[idx];
          if (item.file !== undefined) {
            await callApiUploadStories(item.file, idx);
          }
        }

        const response = (await api({
          url: API_PATHS.updateArtist,
          method: 'POST',
          data: {
            id: route.params.id,
            avatar: avatarUploaded.value,
            artistCode: artistCode.value,
            artistName: artistName.value,
            // eslint-disable-next-line @typescript-eslint/restrict-plus-operands
            birthday: birthday.value + ' 00:00:00',
            sex: sex.value,
            address: address.value,
            phoneNumber: phoneNumber.value,
            email: email.value,
            facebook: facebook.value,
            facebookMessage: facebookMessage.value,
            instagram: instagram.value,
            whatsapp: whatsapp.value,
            fullName: fullName.value,
            // "workStatus": 1,
            shortDescription: null,
            account: null,
            socialEmbedded: socialEmbedded.value,
            artistLevel: artistLevel.value,
            fields: fields.value,
            nationality: nationality.value,
            qualification: qualification.value,
            works: works.value,
            banners: banners.value,
            bankAccounts: bankAccounts.value,
            schedules: schedules.value,
            stories: stories.value,
            products: products.value,
          },
        })) as AxiosResponse<BaseResponseBody<unknown>>;
        if (response.data.error.code === config.API_RES_CODE.OK.code) {
          await Router.push({ name: Pages.artist });
          Notify.create({
            type: 'positive',
            message: i18n.global.t('artist.actionMessages.editArtistAccess'),
          });
        }
      } catch (error) {}
    };
    const DeleteItemStories = (value: StoriesType) => {
      for (let i = 0; i < stories.value.length; i++) {
        if (stories.value[i].id == value.id) {
          console.log(1);
          stories.value.splice(Number(stories.value[i]), 1);
        }
      }
      console.log(stories.value);
    };

    const deleteAvatar = () => {
      avatar.value = null;
    };
    onMounted(() => {
      void getInformationArtist();
      void getFieldOptions();
      void getNationalityOptions();
      void getArtistLevelOptions();
      void getQualificationOptions();
      void getWorkOptions();
      void getBankOptions();
      void getTypeCardOptions();
    });
    return {
      tab,
      getInformationArtist,
      id,
      route,
      artistCode,
      fullName,
      artistName,
      birthday,
      sex,
      nationality,
      address,
      status,
      fields,
      works,
      qualification,
      artistLevel,
      phoneNumber,
      email,
      facebook,
      facebookMessage,
      instagram,
      whatsapp,
      socialEmbedded,
      sexOptions,
      fieldOptions,
      nationalityOptions,
      professionOptions,
      artistLevelOptions,
      workOptions,
      getFieldOptions,
      getNationalityOptions,
      getArtistLevelOptions,
      getQualificationOptions,
      getWorkOptions,
      bankAccounts,
      products,
      account,
      banners,
      shortDescription,
      stories,
      isOpenAddAccountBankDialog,
      openAddHotProduct,
      addAccBank,
      schedules,
      formatSchedules,
      confirmDeleteAccBank,
      selectedFile,
      isOpenDialogEmbed,
      cardBankOptions,
      typeBankOptions,
      isOpenEditAccountBankDialog,
      openDialogEditAccBank,
      editAccBank,
      rowBankAccIdx,
      statusHotProduct,
      DataInsertHotProduct,
      pushData,
      resetOldData,
      reset,
      confirmDeleteRow,
      updateInformationArtist,
      openUpdateHotProduct,
      SetProduct,
      DataUpdateHotProduct,
      UpdateData,
      getBankOptions,
      getTypeCardOptions,
      rowDataAccBank,
      avatar,
      setAvatar,
      deleteAvatar,
      DeleteItemStories,
      confirmDeleteSocialEmbedded,
      changeEmbed,
      isOpenAddStory,
      addStory,
      deleteStory,
      UpdateBirtday,
      checkValidate,
      artistCodeRules,
      fullNameRules,
      artistNameRules,
      birthdayRules,
      emailRules,
      addressRules,
      phoneNumberRules,
      sexRules,
      nationalityRules,
      fieldRules,
      workRules,
      qualificationRules,
      artistLevelRules,
      errorMessEmail,
      errorMessPhoneNumber,
    };
  },
});
