export const config = {
  // lấy động theo url web
  // API_ENDPOINT: '/api/',
  // API_IMAGE_ENDPOINT: '/file/upload/',
  // pro
  API_ENDPOINT: 'https://cms.vab.vn/api/',
  API_IMAGE_ENDPOINT: 'https://cms.vab.vn/file/upload/',
  // dev
  // API_ENDPOINT: 'http://103.147.34.20:10700/api/',
  // API_IMAGE_ENDPOINT: 'http://103.147.34.20:10705/file/upload/',

  API_RES_CODE: {
    OK: {
      code: 0,
    },
    TOKEN_INVALID: {
      code: 3,
    },
    TOKEN_EXPIRES: {
      code: 3,
    },
    '-1': {
      code: -1,
    },
  },
  CHANNEL: 'CMS',
};

export enum API_PATHS {
  login = '/user/login',

  getUserGroups = '/group/get_list',
  getListPages = '/user/page/list',
  getListGroupUsers = '/user/group/list',
  addNewGroupUser = 'user/group/add',
  deleteGroupUser = '/user/group/delete',
  getUserGroupDetail = '/user/group/detail',
  updateUserGroupInfo = '/user/group/update',
  getListUsers = '/user/list',
  addNewUser = '/user/add',
  deleteUser = '/user/delete',
  resetPassword = '/user/resetPass',
  getUserDetail = '/user/detail',
  updateUser = '/user/update',
  getListUnits = '/artistOwner/listManangement',
  getListArtists = '/artist',
  getFieldOptions = '/field',
  getClassificationOptions = '/common/classification',
  getNationalityOptions = '/nationality',
  getProvinceOptions = '/common/province',
  getMusicTypeOptions = '/common/musicType',
  getArtistLevelOptions = '/artistLevel',
  getQualificationOptions = '/qualification',
  getWorkOptions = '/work',
  getDetailArtist = '/artist/detail',
  deleteManagingUnits = '/artistOwner/deleteManagement',
  deleteArtist = '/artist/delete',
  getArtistDicitionaryOptions = 'artist/dictionary',
  artistOwnerAdd = 'artistOwner/addManagement',
  updateArtist = 'artist/update',
  bankOptions = 'bank',
  cardTypeOptions = 'cardType',
  uploadImage = 'file/upload',
  getDetailUnit = 'artistOwner/detailManangement',
  updateUnit = 'artistOwner/updateManagement',
  addArtist = 'artist/add',
  listCustomers = 'customer',
  listCustomerLevel = 'customerLevel',
  addCustomer = 'customer/add',
  deleteCustomer = 'customer/delete',
  browserCustomer = 'customer/accountBrowsing',
  getListCustomersRank = 'customerLevel',
  deleteCustomerRank = 'customerLevel/delete',
  addCustomerRank = 'customerLevel/add',
  updateCustomerRank = 'customerLevel/update',
  getDetailCustomerRank = 'customerLevel/detail',
  getListField = 'field',
  deleteField = 'field/delete',
  addField = 'field/add',
  updateField = 'field/update',
  getDetailField = 'field/detail',
  getListPost = 'post',
  deletePost = 'post/delete',
  detailCustomer = 'customer/detail',
  updateCustomer = 'customer/update',
  getPostCategory = 'postCategory',
  addPost = 'post/add',
  getListCategoryPost = 'postCategory',
  getLanguage = 'language',
  getDetailPost = 'post/detail',
  updatePost = 'post/update',
  addCategoryPost = 'postCategory/add',
  deleteCategoryPost = 'postCategory/delete',
  detailCategoryPost = 'postCategory/detail',
  updateCategoryPost = 'postCategory/update',
  getListBooking = 'booking',
  getBookingDetail = 'booking/detail',
  getArrayArtist = 'artist/arrayArtist',
  getArrayCust = 'customer/arrayCust',
  getlistMenu = 'web-page/list',
  getDetailMenu = 'web-page/detail',
  updateMenu = 'web-page/update',
  addMenu = 'web-page/add',
  deleteMenu = 'web-page/delete',
  getConfigSystem = 'config-page',
  getDetailConfigSystem = 'config-page/detail',
  updateConfigSystem = 'config-page/update',
  addConfigSystem = 'config-page/add',
  deleteConfigSystem = 'config-page/delete',
  getDetailInfoVAB = 'information/detail',
  updateInfoVAB = 'information/update',
  getListVABInfo = 'information',
  getListBanner = 'config/home/banner',
  getDetailBanner = 'config/home/banner/detail',
  addBanner = 'config/home/banner/add',
  updateBanner = 'config/home/banner/update',
  deleteBanner = 'config/home/banner/delete',
  getListConfigPartner = 'config/home/partner',
  deleteConfigPartner = 'config/home/partner/delete',
  addConfigPartner = 'config/home/partner/add',
  getDetailConfigPartner = 'config/home/partner/detail',
  updateConfigPartner = 'config/home/partner/update',
  getListConfigHotProduct = 'config/home/product',
  getDetailConfigHotProduct = 'config/home/product/detail',
  updateConfigHotProduct = 'config/home/product/update/salient',
  addConfigHotProduct = 'config/home/product/add/salient',
  deleteConfigHotProduct = 'config/home/product/delete/salient',
  getLitCustomerWaiting = 'customer/listRegister',
  detailCustomerWaiting = 'customer/detailRegister',
  accountCustomerBrowsing = 'customer/accountCustomerBrowsing',
  customerNotBrowsing = 'customer/customerNotBrowsing',
  getListRegister = 'artist/getListRegister',
  accountArtistBrowsing = 'customer/accountArtistBrowsing',
  detailRegisterArtist = 'artist/detailRegister',
  listBookingNotApproval = 'booking/notApproval',
  bookingBrowsing = 'booking/bookingBrowsing',
  getListDeposit = 'deposit',
  formalityDeposit = 'common/formalityDeposit', // danh sách hình thức đặt cọc
  configHomeProduct = 'config/home/product',
  artistFeaturedProduct = 'artist/featuredProduct',
  homeProductNotActive = 'config/home/productNotActive',
  artistFeaturedProducts = 'artist/featuredProducts',

  // duyệt chủ quản
  artistOwnerBrowseManagement = 'artistOwner/browseManagement',
  // thêm người dùng vào nhóm
  addUser = 'user/group/addUser',
  importExcel = 'artist/importExcel',
  exportExcel = 'artist/exportExcel',
  // trang cấu hình liveStream
  livestream = 'livestream/list',
  updateLiveStream = 'livestream/update',

  // thêm sản phẩm nổi bật
  homeAddProduct = 'config/home/addProduct',

  // danh sách công việc
  workList = 'work/list',

  // thêm công việc
  workAdd = 'work/add',

  // chi tiết công việc
  workDetail = 'work/detail',

  // cập nhật công việc
  workUpdate = 'work/update',

  // xóa công việc
  workDelete = 'work/delete',
}
