import { defineComponent, Ref, ref, watch } from 'vue';
import { i18n } from 'src/boot/i18n';
import { Notify } from 'quasar';
import UploadImage from '../../upload-image/index.vue';
import { Cropper } from 'vue-advanced-cropper';
import { Coordinates } from 'src/assets/type';
// import { Preview } from 'vue-advanced-cropper';
import 'vue-advanced-cropper/dist/style.css';
export default defineComponent({
  components: {
    UploadImage,
    Cropper,
  },

  props: {
    openAddHotProduct: {
      type: Boolean,
      requied: true,
    },
  },

  setup(props, context) {
    const imageCrop = ref();
    const fileCrop = ref();
    const urlCrop: Ref<string> = ref('');
    const dialogCrop = ref(false);
    const file: Ref<File | string> = ref('');
    const name: Ref<string> = ref('');
    const code: Ref<string> = ref('');
    const embeddedUrl: Ref<string> = ref('');
    const urlFileLocal: Ref<string> = ref('');
    const status: Ref<number> = ref(2);

    const isFeaturedOnHomepage: Ref<number> = ref(0);
    const statusOptions = ref([
      { id: 1, name: 'Sản phẩm khác' },
      { id: 2, name: 'Sản phẩm nổi bật' },
    ]);
    const uploadAvatar = (value: FileList) => {
      console.log(value, 'value');
      dialogCrop.value = true;
      imageCrop.value = URL.createObjectURL(value[0]);

      // urlFileLocal.value = URL.createObjectURL(value[0]);
      // file.value = value[0];
    };

    const handeDialogCrop = () => {
      imageCrop.value = null;
      dialogCrop.value = false;
    };



    const changeCrop = (coordinates: Coordinates) => {
      // eslint-disable-next-line
      // @ts-ignore
      // eslint-disable-next-line
      urlCrop.value = coordinates.canvas.toDataURL();
      // eslint-disable-next-line
      // @ts-ignore
      // eslint-disable-next-line
      fetch(urlCrop.value)
        .then((res) => res.blob())
        .then((blob) => {
          const file = new File([blob], 'file-1678935701090.jpg', {
            type: blob.type,
          });
          fileCrop.value = file;
        });
    };


    const onOKCrop = () => {
      // context.emit('SetAvatar', {
      //   file: fileCrop.value as File,
      //   url: urlCrop.value,
      // });
      // eslint-disable-next-line
      // @ts-ignore
      // eslint-disable-next-line
      urlFileLocal.value = urlCrop.value;
    
      // eslint-disable-next-line
      // @ts-ignore
      // eslint-disable-next-line
      file.value = fileCrop.value;
      dialogCrop.value = false;
    };


    watch(
      () => props.openAddHotProduct,
      (value) => {
        if (value) {
          ResetData();
        }
      }
    );
    const ResetData = () => {
      file.value = '';
      code.value = '';
      name.value = '';
      embeddedUrl.value = '';
      urlFileLocal.value = '';
      status.value = 2;
      isFeaturedOnHomepage.value = 0;
    };
    const SubmitData = () => {
      context.emit('click:CloseBtnAddHotProduct');
      context.emit('insertData', {
        file: file.value,
        name: name.value,
        code: code.value,
        status: status.value,
        embeddedUrl: embeddedUrl.value,
        imageUrl: urlFileLocal.value,
        isFeaturedOnHomepage: isFeaturedOnHomepage.value,
      });
      Notify.create({
        type: 'positive',
        message: i18n.global.t(
          'artist.dialogLabel.validateMessages.addHotProductSccess'
        ),
        actions: [{ icon: 'close', color: 'white' }],
      });
    };

    const product_name = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireProducName'
        ),
    ];

    const product_code = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireProducCode'
        ),
    ];
    const url_embed = [
      (val?: string) =>
        (val && val.trim().length) ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireUrlembed'
        ),
    ];
    const statusRules = [
      (val?: number) =>
        val !== undefined ||
        i18n.global.t(
          'artist.artistInformation.validateMessages.requireStatus'
        ),
    ];

    return {
      uploadAvatar,
      SubmitData,
      changeCrop,
      handeDialogCrop,
      onOKCrop,
      imageCrop,
      fileCrop,
      urlCrop,
      dialogCrop,
      urlFileLocal,
      file,
      name,
      code,
      embeddedUrl,
      status,
      ResetData,
      product_name,
      product_code,
      url_embed,
      statusRules,
      statusOptions,
    };
  },

  emits: [
    'insertData',
    'update:openAddHotProduct',
    'update:statusHotProduct',
    'selectedFile',
    'click:CloseBtnAddHotProduct',
  ],
});
