import { i18n } from 'src/boot/i18n';
import { defineComponent, Ref, ref } from 'vue';
import Pagination from 'components/pagination/index.vue';
import { ProductType } from 'src/assets/type';
import { HotProductStatus } from 'src/assets/enums';

import { Dialog, Notify } from 'quasar';
import { AxiosResponse } from 'axios';
import { config, API_PATHS } from 'src/assets/configurations.example';
import { api, BaseResponseBody } from 'src/boot/axios';
export default defineComponent({
  components: {
    Pagination,
  },
  props: {
    products: { type: Array, required: true },
    // DataInsertHotProduct: { type: Object, requied: false }
  },
  setup(_, context) {
    
    const configImg = config;
    const userTableColumnsHotProduct = [
      {
        name: 'name',
        field: 'name',
        required: true,
        label: i18n.global.t('artist.hotProduct.tableColumnsProduct.name'),
        headerStyle: 'text-align: center !important;',
        align: 'left',
        sortable: false,
      },
      {
        name: 'code',
        field: 'code',
        required: true,
        label: i18n.global.t(
          'artist.hotProduct.tableColumnsProduct.productCode'
        ),
        align: 'center',
        sortable: false,
      },
      {
        name: 'embeddedUrl',
        field: 'embeddedUrl',
        required: true,
        label: i18n.global.t('artist.hotProduct.tableColumnsProduct.urlEmbed'),
        headerStyle: 'text-align: center !important;',
        align: 'left',
        sortable: false,
      },
      {
        name: 'imageUrl',
        field: 'imageUrl',
        required: true,
        label: i18n.global.t(
          'artist.hotProduct.tableColumnsProduct.productImage'
        ),
        align: 'center',
        sortable: false,
      },
      {
        name: 'status',
        field: 'status',
        required: true,
        label: i18n.global.t('artist.hotProduct.tableColumnsProduct.status'),
        align: 'center',
        sortable: false,
      },

      {
        name: 'isFeaturedOnHomepage',
        field: 'isFeaturedOnHomepage',
        required: true,
        label: 'Nổi bật ở trang chủ',
        align: 'center',
        sortable: false,
      },

      {
        name: 'action',
        field: 'action',
        required: true,
        label: i18n.global.t('artist.bankAccount.tableColumnsBank.action'),
        align: 'center',
        sortable: false,
      },
    ];

    const userTableRowsHotProduct: Ref<unknown[]> = ref([]);
    const pageIndex = ref(1);
    const pageSize = ref(20);
    const totalPage = ref(10);

    const updateProduct = (item: { row: ProductType }) => {
      context.emit('setDataUpdate', {
        code: item.row.code,
        embeddedUrl: item.row.embeddedUrl,
        id: item.row.id,
        imageUrl: item.row.imageUrl,
        name: item.row.name,
        status: item.row.status,
        file: item.row.file,
        isFeaturedOnHomepage: item.row.isFeaturedOnHomepage,
      });
      context.emit('click:openUpdateHotProduct');
      
    };
   // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access

    const  showHiden = (index: any) => {
        Dialog.create({
          title: i18n.global.t(
            'managingUnit.confirmActionsTitle.confirmDeleteManagingUnitsTitle'
          ),
             // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
          message: index.isFeaturedOnHomepage === 1 ? 'Bạn có chắc chắn muốn ẩn ở trang chủ không?'  :  'Bạn có chắc chắn muốn hiển thị ở trang chủ không?',
          cancel: i18n.global.t(
            'managingUnit.confirmActionsTitle.confirmDeleteManagingUnitsCancelBtnLabel'
          ),
          color: 'negative',
        }).onOk( () => {
          void deleteBanner(index);
         // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
        });
    }
    const deleteBanner = async (index: {id: number, isFeaturedOnHomepage :number}) =>{
      try {
        const  deleteResult = (await api({
          url: API_PATHS.artistFeaturedProduct,
          method: 'GET',
          params: {
            id: index?.id,
            isFeaturedOnHomepage: index?.isFeaturedOnHomepage === 1 ? 0 : 1 ,
          },
        })) as AxiosResponse<BaseResponseBody<unknown>>;
        if (deleteResult.data.error.code === config.API_RES_CODE.OK.code) {
          context.emit('click:updateStatusHot');
          Notify.create({
            type: 'positive',
            message: 'Thay đổi trạng thái thành công',
            actions: [{ icon: 'close', color: 'white' }],
          });
        }
      } catch (error) {}
    }


    const clickAdd = () => {
      context.emit('click:addHotProduct');
    };
    const deleteRow = (index: number) => {
      context.emit('deleteRow', index);
    };

    return {
      configImg,
      userTableColumnsHotProduct,
      userTableRowsHotProduct,
      pageIndex,
      pageSize,
      totalPage,
      deleteRow,
      clickAdd,
      updateProduct,
      showHiden,
      HotProductStatus,
    
    };
  },
  emits: [
    'click:addHotProduct',
    'reset',
    'deleteRow',
    'click:openUpdateHotProduct',
    'setDataUpdate',
    'click:updateStatusHot'
  ],
});
