import { i18n } from 'src/boot/i18n';
import { defineComponent, onMounted, Ref, ref } from 'vue';
import Pagination from 'components/pagination/index.vue';
import { BookingStatus } from 'src/assets/enums';
import { ActiveStatus } from 'src/assets/enums';
import { config, API_PATHS } from 'src/assets/configurations.example';
import { api, BaseResponseBody } from 'src/boot/axios';
import { AxiosResponse } from 'axios';
import { listWorksType } from 'src/assets/type';
import addWorks from '../../components/cong-viec/add.vue';
import updateWorks from '../../components/cong-viec/update.vue';
import { Dialog, Notify } from 'quasar';
export default defineComponent({
  components: {
    Pagination,
    addWorks,
    updateWorks,
  },
  setup() {
    const tableColumns = [
      {
        name: 'stt',
        field: 'stt',
        required: true,
        label: i18n.global.t('work.titleColumnsTable.stt'),
        align: 'center',
        sortable: false,
      },
      {
        name: 'workName',
        field: 'name',
        required: true,
        label: i18n.global.t('work.titleColumnsTable.workName'),
        align: 'center',
        headerStyle: 'text-align: center !important;',
        sortable: false,
      },

      {
        name: 'status',
        field: 'status',
        required: true,
        label: 'Trạng thái',
        align: 'center',
        headerStyle: 'text-align: center !important;',
        sortable: false,
      },

      {
        name: 'action',
        field: 'action',
        required: true,
        label: i18n.global.t('work.titleColumnsTable.action'),
        align: 'center',
        sortable: false,
      },
    ];
    const openDialogUpdate = ref(false);
    const openDialogAdd = ref(false);

    const listWorks: Ref<listWorksType[]> = ref([]);
    const pageIndex = ref(1);
    const pageSize = ref(20);
    const totalPage = ref(10);
    const keywordSearch: Ref<string | null> = ref(null);

    const idItem: Ref<number> = ref(0);
    const changePageSize = () => {
      pageIndex.value = 1;
      void getListWorks();
    };

    const confirmUpdate = (value: number) => {
      idItem.value = value;
      openDialogUpdate.value = true;
    };
    const confirmDelete = (id: number) => {
      Dialog.create({
        title: i18n.global.t(
          'field.confirmActionsTitle.confirmDeleteFieldTitle'
        ),
        message: 'Bạn chắc chắn muốn xóa công việc này?',
        cancel: i18n.global.t(
          'field.confirmActionsTitle.confirmDeleteFieldCancelBtnLabel'
        ),
        color: 'negative',
      }).onOk(() => {
        void deleteField(id);
      });
    };

    const deleteField = async (id: number) => {
      try {
        const deleteResult = (await api({
          url: API_PATHS.workDelete,
          method: 'GET',
          params: {
            id: id,
          },
        })) as AxiosResponse<BaseResponseBody<unknown>>;

        if (deleteResult.data.error.code === config.API_RES_CODE.OK.code) {
          Notify.create({
            type: 'positive',
            message: 'Xóa công việc thành công',
            actions: [{ icon: 'close', color: 'white' }],
          });
          void getListWorks();
        }
      } catch (error) {}
    };

    const getListWorks = async () => {
      const response = (await api({
        url: API_PATHS.workList,
        method: 'GET',
        params: {
          name: keywordSearch.value,
        },
      })) as AxiosResponse<BaseResponseBody<listWorksType[]>>;
      if (response.data.error.code === config.API_RES_CODE.OK.code) {
        console.log(response.data.data, 'response.data.data');
        listWorks.value = response.data.data;
      }
      // console.log('API List Menu');
    };

    onMounted(() => {
      void getListWorks();
    });
    return {
      keywordSearch,
      status,
      listWorks,
      tableColumns,
      pageIndex,
      pageSize,
      openDialogAdd,
      openDialogUpdate,
      totalPage,
      idItem,
      changePageSize,
      getListWorks,
      confirmUpdate,
      confirmDelete,
      BookingStatus,
      ActiveStatus,
    };
  },
});
